/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import java.io.Serializable;
import java.util.Vector;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.EquipmentType;
import megamek.common.IGame;
import megamek.common.actions.WeaponAttackAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtilleryAttackAction
extends WeaponAttackAction
implements Serializable {
    private static final long serialVersionUID = -3893844894076028005L;
    public int turnsTilHit;
    private Vector<Integer> spotterIds;
    protected int playerId;
    private Coords firingCoords;

    public ArtilleryAttackAction(int n, int n2, int n3, int n4, IGame iGame) {
        super(n, n2, n3, n4);
        this.playerId = iGame.getEntity(n).getOwnerId();
        this.firingCoords = iGame.getEntity(n).getPosition();
        int n5 = Compute.effectiveDistance(iGame, this.getEntity(iGame), this.getTarget(iGame));
        n5 = (int)Math.floor((double)n5 / (double)iGame.getPlanetaryConditions().getGravity());
        EquipmentType equipmentType = iGame.getEntity(n).getEquipment(n4).getType();
        this.turnsTilHit = equipmentType.hasFlag(0x800000000L) ? 1 + n5 / 17 / 5 : (n5 <= 17 ? 0 : (n5 <= 136 ? 1 : (n5 <= 255 ? 2 : (n5 <= 357 ? 3 : (n5 <= 442 ? 4 : 5)))));
    }

    public Vector<Integer> getSpotterIds() {
        return this.spotterIds;
    }

    public int getPlayerId() {
        return this.playerId;
    }

    public void setSpotterIds(Vector<Integer> vector) {
        this.spotterIds = vector;
    }

    public void setCoords(Coords coords) {
        this.firingCoords = coords;
    }

    public Coords getCoords() {
        return this.firingCoords;
    }
}

