/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.MissileWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreakHandler
extends MissileWeaponHandler {
    private static final long serialVersionUID = 4122111574368642492L;
    boolean isAngelECMAffected;

    public StreakHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.isAngelECMAffected = Compute.isAffectedByAngelECM(this.ae, this.ae.getPosition(), this.target.getPosition());
    }

    @Override
    protected int calcDamagePerHit() {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            int n = Compute.directBlowInfantryDamage(this.wtype.getRackSize() * 2, this.bDirect ? this.toHit.getMoS() / 3 : 0, 3, ((Infantry)this.target).isMechanized());
            return n;
        }
        return 2;
    }

    @Override
    protected int calcnCluster() {
        return 1;
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        int n;
        int n2;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            if (this.ae instanceof BattleArmor) {
                this.bSalvo = true;
                return ((BattleArmor)this.ae).getShootingStrength();
            }
            return 1;
        }
        if (this.bMissed) {
            return 0;
        }
        int n3 = this.nSalvoBonus;
        if (this.game.getOptions().booleanOption("tacops_range") && this.nRange > this.wtype.getRanges(this.weapon)[3]) {
            n3 -= 2;
        }
        if (this.game.getPlanetaryConditions().hasEMI()) {
            n3 -= 2;
        }
        if (this.bDirect) {
            n3 += this.toHit.getMoS() / 3 * 2;
        }
        if ((n2 = this.getAMSHitsMod(vector) + n3) == 0) {
            n = this.wtype.getRackSize();
        } else {
            n = Compute.missilesHit(this.wtype.getRackSize(), n2, this.weapon.isHotLoaded(), true, this.advancedAMS);
            if (n2 != 0) {
                this.r = n2 > 0 ? new Report(3340) : new Report(3341);
                this.r.subject = this.subjectId;
                this.r.add(n2);
                this.r.newlines = 0;
                vector.addElement(this.r);
            }
        }
        if (n > 0) {
            this.r = new Report(3325);
            this.r.subject = this.subjectId;
            this.r.add(n);
            this.r.add(this.sSalvoType);
            this.r.add(this.toHit.getTableDesc());
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        this.r = new Report(3345);
        this.r.subject = this.subjectId;
        this.r.newlines = 0;
        vector.addElement(this.r);
        this.bSalvo = true;
        return n;
    }

    @Override
    protected void useAmmo() {
        this.checkAmmo();
        if (this.ammo == null) {
            System.out.println("Handler can't find any ammo!  Oh no!");
        }
        if (this.ammo.getShotsLeft() <= 0) {
            this.ae.loadWeaponWithSameAmmo(this.weapon);
            this.ammo = this.weapon.getLinked();
        }
        if (this.roll >= this.toHit.getValue()) {
            this.ammo.setShotsLeft(this.ammo.getShotsLeft() - 1);
            this.setDone();
        }
    }

    @Override
    protected void reportMiss(Vector<Report> vector) {
        Report report = new Report(3215);
        report.subject = this.subjectId;
        vector.addElement(report);
    }

    @Override
    protected void addHeat() {
        if (this.toHit.getValue() != Integer.MAX_VALUE && this.roll >= this.toHit.getValue()) {
            this.ae.heatBuildup += this.wtype.getHeat();
        }
    }

    @Override
    protected boolean allShotsHit() {
        return super.allShotsHit() || !this.isAngelECMAffected;
    }

    @Override
    protected boolean handleSpecialMiss(Entity entity, boolean bl, Building building, Vector<Report> vector) {
        return false;
    }

    @Override
    protected boolean canDoDirectBlowDamage() {
        return false;
    }
}

