/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.xml;

import gd.xml.tiny.ParsedXML;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Protomech;

public class ProtomechEncoder {
    public static void encode(Entity entity, Writer writer) throws IOException {
        Protomech protomech = (Protomech)entity;
        if (null == entity) {
            throw new IllegalArgumentException("The entity is null.");
        }
        if (null == writer) {
            throw new IllegalArgumentException("The writer is null.");
        }
        writer.write("<bv value=\"");
        int n = (int)((double)protomech.calculateBattleValue() / protomech.getCrew().getBVSkillMultiplier());
        writer.write(n);
        writer.write("\" /><hasMainGun value=\"");
        writer.write(protomech.hasMainGun() ? "true" : "false");
        for (int i = 0; i < protomech.locations(); ++i) {
            writer.write("\" /><pilotDamageTaken loc=\"");
            writer.write(i);
            writer.write("\" value=\"");
            n = protomech.getPilotDamageTaken(i);
            writer.write(n);
        }
        writer.write("\" />");
    }

    public static Entity decode(ParsedXML parsedXML, IGame iGame) {
        Protomech protomech = null;
        if (null == parsedXML) {
            throw new IllegalArgumentException("The Protomech node is null.");
        }
        String string = parsedXML.getAttribute("name");
        if (!parsedXML.getName().equals("class") || null == string || !string.equals("Protomech")) {
            throw new IllegalStateException("Not passed an Protomech node.");
        }
        protomech = new Protomech();
        Enumeration enumeration = parsedXML.elements();
        while (enumeration.hasMoreElements()) {
            int n;
            int n2;
            ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
            String string2 = parsedXML2.getName();
            if (null == string2) continue;
            if (string2.equals("hasMainGun")) {
                string = parsedXML2.getAttribute("value");
                if (null == string) {
                    throw new IllegalStateException("Couldn't decode hasMainGun for a Protomech unit.");
                }
                if (string.equals("true")) {
                    protomech.setHasMainGun(true);
                    continue;
                }
                protomech.setHasMainGun(false);
                continue;
            }
            if (!string2.equals("pilotDamageTaken")) continue;
            string = parsedXML2.getAttribute("value");
            if (null == string) {
                throw new IllegalStateException("Couldn't decode the damage for a Protomech unit.");
            }
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Couldn't get an integer from " + string);
            }
            string = parsedXML2.getAttribute("loc");
            if (null == string) {
                throw new IllegalStateException("Couldn't decode the location for a Protomech unit.");
            }
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Couldn't get an integer from " + string);
            }
            protomech.setPilotDamageTaken(n, n2);
        }
        return protomech;
    }
}

