/*
 * Decompiled with CFR 0.152.
 */
package megamek.server.commands;

import megamek.server.Server;
import megamek.server.commands.ServerCommand;

public class SeeAllCommand
extends ServerCommand {
    public SeeAllCommand(Server server) {
        super(server, "seeall", "Allows player to see all in double blind game if you are an observer.  Usage: /seeall <password> <player id#>.   For a list of player id #s, use the /who command (default is yourself)");
    }

    public void run(int n, String[] stringArray) {
        int n2;
        boolean bl = this.server.getGame().getOptions().booleanOption("double_blind");
        int n3 = n2 = this.server.isPassworded() ? 2 : 1;
        if (!bl) {
            this.server.sendServerChat(n, "Double Blind rules not in effect.");
            return;
        }
        if (this.server.isPassworded() && (stringArray.length < 2 || !this.server.isPassword(stringArray[1]))) {
            this.server.sendServerChat(n, "The password is incorrect.  Usage: /seeall <password> <id#>");
        } else {
            try {
                int n4 = stringArray.length <= n2 ? n : Integer.parseInt(stringArray[n2]);
                boolean bl2 = this.server.getPlayer(n4).getSeeAll();
                String string = bl2 ? " no longer has" : " has been granted";
                if (n4 == n) {
                    this.server.sendServerChat(this.server.getPlayer(n4).getName() + string + " vision of the entire map");
                } else {
                    this.server.sendServerChat(this.server.getPlayer(n4).getName() + string + " vision of the entire map by " + this.server.getPlayer(n).getName());
                }
                this.server.getPlayer(n4).setSeeAll(!bl2);
                this.server.sendEntities(n4);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.server.sendServerChat("/seeall : seeall failed.  Type /who for a list of players with id #s.");
            }
            catch (NumberFormatException numberFormatException) {
                this.server.sendServerChat("/seeall : seeall failed.  Type /who for a list of players with id #s.");
            }
            catch (NullPointerException nullPointerException) {
                this.server.sendServerChat("/seeall : seeall failed.  Type /who for a list of players with id #s.");
            }
        }
    }
}

