/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractDomFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractDitaMetaWriter
extends AbstractDomFilter {
    private static final Set<DitaClass> uniqueSet = Collections.unmodifiableSet(new HashSet<DitaClass>(Arrays.asList(Constants.TOPIC_CRITDATES, Constants.TOPIC_PERMISSIONS, Constants.TOPIC_PUBLISHER, Constants.TOPIC_SOURCE, Constants.MAP_SEARCHTITLE, Constants.TOPIC_SEARCHTITLE)));
    private Map<String, Element> metaTable;
    private String topicid = null;

    public void setMetaTable(Map<String, Element> metaTable) {
        this.metaTable = metaTable;
    }

    public void setTopicId(String topicid) {
        this.topicid = topicid;
    }

    @Override
    public abstract Document process(Document var1);

    void processMetadata(Element metadataContainer, List<DitaClass> order) {
        for (int i = 0; i < order.size(); ++i) {
            DitaClass cls = order.get(i);
            List<Element> newChildren = this.getNewChildren(cls, metadataContainer.getOwnerDocument());
            if (newChildren.isEmpty()) continue;
            Element insertPoint = this.getInsertionRef(metadataContainer, order.subList(i, order.size()));
            for (Element newChild : newChildren) {
                if (this.skipUnlockedNavtitle(metadataContainer, newChild)) continue;
                if (insertPoint != null) {
                    if (uniqueSet.contains(cls) && cls.matches(insertPoint)) {
                        metadataContainer.replaceChild(newChild, insertPoint);
                        continue;
                    }
                    metadataContainer.insertBefore(newChild, insertPoint);
                    continue;
                }
                metadataContainer.appendChild(newChild);
            }
        }
    }

    boolean hasMetadata(List<DitaClass> order) {
        for (DitaClass cls : order) {
            if (!this.metaTable.containsKey(cls.matcher)) continue;
            return true;
        }
        return false;
    }

    boolean skipUnlockedNavtitle(Element metadataContainer, Element checkForNavtitle) {
        if (!Constants.TOPIC_TITLEALTS.matches(metadataContainer) || !Constants.TOPIC_NAVTITLE.matches(checkForNavtitle)) {
            return false;
        }
        if (checkForNavtitle.getAttributeNodeNS("http://dita-ot.sourceforge.net/ns/201007/dita-ot", "locktitle") == null) {
            return false;
        }
        return !"yes".matches(checkForNavtitle.getAttributeNodeNS("http://dita-ot.sourceforge.net/ns/201007/dita-ot", "locktitle").getValue());
    }

    private List<Element> getNewChildren(DitaClass cls, Document doc) {
        ArrayList<Element> res = new ArrayList<Element>();
        if (this.metaTable.containsKey(cls.matcher)) {
            this.metaTable.get(cls.matcher);
            NodeList list = this.metaTable.get(cls.matcher).getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node item = list.item(i);
                res.add((Element)doc.importNode(item, true));
            }
        }
        Collections.reverse(res);
        return res;
    }

    private Element getInsertionRef(Element metadataContainer, List<DitaClass> order) {
        if (order.isEmpty()) {
            return null;
        }
        Element elem = this.getFirstChildElement(metadataContainer, order.get(0));
        if (elem != null) {
            return elem;
        }
        return this.getInsertionRef(metadataContainer, order.subList(1, order.size()));
    }

    Element findMetadataContainer(Element root, List<DitaClass> position, DitaClass container) {
        Element prolog = this.getFirstChildElement(root, container);
        if (prolog == null) {
            prolog = root.getOwnerDocument().createElement(container.localName);
            prolog.setAttribute("class", container.toString());
            Element insertPoint = null;
            for (int i = position.size() - 1; i >= 0 && (insertPoint = this.getLastChildElement(root, position.get(i))) == null; --i) {
            }
            if (insertPoint != null) {
                this.insertAfter(prolog, insertPoint);
            } else if (root.hasChildNodes()) {
                root.insertBefore(prolog, root.getFirstChild());
            } else {
                root.appendChild(prolog);
            }
        }
        return prolog;
    }

    Element getFirstChildElement(Element root, DitaClass cls) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element elem;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !cls.matches(elem = (Element)child)) continue;
            return elem;
        }
        return null;
    }

    private Element getLastChildElement(Element root, DitaClass cls) {
        Element res = null;
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element elem;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !cls.matches(elem = (Element)child)) continue;
            res = elem;
        }
        return res;
    }

    public Element getMatchingTopicElement(Element root) {
        Element res;
        if (this.topicid != null && (res = this.matchTopicElementById(root)) != null) {
            return res;
        }
        return this.matchFirstTopicInDoc(root);
    }

    private Element matchFirstTopicInDoc(Element root) {
        if (root.getTagName().equals("dita")) {
            return this.getFirstChildElement(root, Constants.TOPIC_TOPIC);
        }
        return root;
    }

    private Element matchTopicElementById(Element topic) {
        if (topic.getAttribute("id").equals(this.topicid)) {
            return topic;
        }
        for (Element elem : XMLUtils.getChildElements(topic)) {
            Element res = this.matchTopicElementById(elem);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private void insertAfter(Node newChild, Node refChild) {
        Node next = refChild.getNextSibling();
        Node parent = refChild.getParentNode();
        if (next != null) {
            parent.insertBefore(newChild, next);
        } else {
            parent.appendChild(newChild);
        }
    }
}

