/*
 * Decompiled with CFR 0.152.
 */
package jrm.io.torrent.bencoding;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jrm.io.torrent.bencoding.types.BByteString;
import jrm.io.torrent.bencoding.types.BDictionary;
import jrm.io.torrent.bencoding.types.BInt;
import jrm.io.torrent.bencoding.types.BList;
import jrm.io.torrent.bencoding.types.IBencodable;
import org.apache.commons.io.IOUtils;

public class Reader {
    private int currentByteIndex;
    private byte[] datablob;

    public Reader(File file) throws IOException {
        this.datablob = IOUtils.toByteArray(new FileInputStream(file));
    }

    public Reader(String s) {
        this.datablob = s.getBytes();
    }

    public synchronized List<IBencodable> read() {
        this.currentByteIndex = 0;
        long fileSize = this.datablob.length;
        ArrayList<IBencodable> dataTypes = new ArrayList<IBencodable>();
        while ((long)this.currentByteIndex < fileSize) {
            dataTypes.add(this.readSingleType());
        }
        return dataTypes;
    }

    private IBencodable readSingleType() {
        byte current = this.datablob[this.currentByteIndex];
        switch (current) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.readByteString();
            }
            case 100: {
                return this.readDictionary();
            }
            case 105: {
                return this.readInteger();
            }
            case 108: {
                return this.readList();
            }
        }
        throw new Error("Parser in invalid state at byte " + this.currentByteIndex);
    }

    private BList readList() {
        if (this.readCurrentByte() != 108) {
            throw new Error("Error parsing list. Was expecting a 'l' but got " + this.readCurrentByte());
        }
        ++this.currentByteIndex;
        BList list = new BList();
        while (this.readCurrentByte() != 101) {
            list.add(this.readSingleType());
        }
        ++this.currentByteIndex;
        return list;
    }

    private BByteString readByteString() {
        String lengthAsString = "";
        byte current = this.readCurrentByte();
        while (current >= 48 && current <= 57) {
            lengthAsString = lengthAsString + Character.toString((char)current);
            ++this.currentByteIndex;
            current = this.readCurrentByte();
        }
        int lengthAsInt = Integer.parseInt(lengthAsString);
        if (this.readCurrentByte() != 58) {
            throw new Error("Read length of byte string and was expecting ':' but got " + this.readCurrentByte());
        }
        ++this.currentByteIndex;
        byte[] bsData = new byte[lengthAsInt];
        for (int i = 0; i < lengthAsInt; ++i) {
            bsData[i] = this.readCurrentByte();
            ++this.currentByteIndex;
        }
        return new BByteString(bsData);
    }

    private BDictionary readDictionary() {
        if (this.readCurrentByte() != 100) {
            throw new Error("Error parsing dictionary. Was expecting a 'd' but got " + this.readCurrentByte());
        }
        ++this.currentByteIndex;
        BDictionary dict = new BDictionary();
        while (this.readCurrentByte() != 101) {
            BByteString key = (BByteString)this.readSingleType();
            IBencodable value = this.readSingleType();
            dict.add(key, value);
        }
        ++this.currentByteIndex;
        return dict;
    }

    private BInt readInteger() {
        if (this.readCurrentByte() != 105) {
            throw new Error("Error parsing integer. Was expecting an 'i' but got " + this.readCurrentByte());
        }
        ++this.currentByteIndex;
        String intString = "";
        byte current = this.readCurrentByte();
        while (current >= 48 && current <= 57 || current == 45) {
            intString = intString + Character.toString((char)current);
            ++this.currentByteIndex;
            current = this.readCurrentByte();
        }
        if (this.readCurrentByte() != 101) {
            throw new Error("Error parsing integer. Was expecting 'e' at end but got " + this.readCurrentByte());
        }
        ++this.currentByteIndex;
        return new BInt(Long.parseLong(intString));
    }

    private byte readCurrentByte() {
        return this.datablob[this.currentByteIndex];
    }
}

