/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.data;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jrm.locale.Messages;
import jrm.profile.data.MachineList;
import jrm.profile.data.SoftwareList;

public final class AnywareListListRenderer {
    public static final String[] columns = new String[]{Messages.getString("SoftwareListListRenderer.Name"), Messages.getString("SoftwareListListRenderer.Description"), Messages.getString("SoftwareListListRenderer.Have")};
    public static final Class<?>[] columnsTypes = new Class[]{Object.class, String.class, String.class};
    public static final int[] columnsWidths = new int[]{70, 150, -80};
    public static final TableCellRenderer[] columnsRenderers = new TableCellRenderer[]{new DefaultTableCellRenderer(){
        ImageIcon disk_multiple_green = new ImageIcon(AnywareListListRenderer.class.getResource("/jrm/resources/disk_multiple_green.png"));
        ImageIcon disk_multiple_orange = new ImageIcon(AnywareListListRenderer.class.getResource("/jrm/resources/disk_multiple_orange.png"));
        ImageIcon disk_multiple_red = new ImageIcon(AnywareListListRenderer.class.getResource("/jrm/resources/disk_multiple_red.png"));
        ImageIcon disk_multiple_gray = new ImageIcon(AnywareListListRenderer.class.getResource("/jrm/resources/disk_multiple_gray.png"));

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof SoftwareList) {
                super.getTableCellRendererComponent(table, ((SoftwareList)value).getBaseName(), isSelected, hasFocus, row, column);
                switch (((SoftwareList)value).getStatus()) {
                    case COMPLETE: {
                        this.setIcon(this.disk_multiple_green);
                        break;
                    }
                    case MISSING: {
                        this.setIcon(this.disk_multiple_red);
                        break;
                    }
                    case PARTIAL: {
                        this.setIcon(this.disk_multiple_orange);
                        break;
                    }
                    default: {
                        this.setIcon(this.disk_multiple_gray);
                    }
                }
                return this;
            }
            if (value instanceof MachineList) {
                super.getTableCellRendererComponent(table, Messages.getString("MachineListListRenderer.*"), isSelected, hasFocus, row, column);
                switch (((MachineList)value).getStatus()) {
                    case COMPLETE: {
                        this.setIcon(this.disk_multiple_green);
                        break;
                    }
                    case MISSING: {
                        this.setIcon(this.disk_multiple_red);
                        break;
                    }
                    case PARTIAL: {
                        this.setIcon(this.disk_multiple_orange);
                        break;
                    }
                    default: {
                        this.setIcon(this.disk_multiple_gray);
                    }
                }
                return this;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }, new DefaultTableCellRenderer(), new DefaultTableCellRenderer(){
        {
            this.setHorizontalAlignment(0);
        }
    }};

    private AnywareListListRenderer() {
    }
}

