/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.manager;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import jrm.locale.Messages;
import jrm.profile.manager.ProfileNFO;
import jrm.ui.profile.manager.FileTableModel;

public class FileTableCellRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (column == 0 && table.getModel() instanceof FileTableModel) {
            ProfileNFO nfo = ((FileTableModel)table.getModel()).getNfoAt(row);
            super.getTableCellRendererComponent(table, nfo.name, isSelected, hasFocus, row, column);
            switch (nfo.mame.getStatus()) {
                case UPTODATE: {
                    this.setForeground(Color.decode("0x00aa00"));
                    this.setToolTipText(String.format(Messages.getString("FileTableCellRenderer.IsUpToDate"), nfo.name));
                    break;
                }
                case NEEDUPDATE: {
                    this.setForeground(Color.decode("0xcc8800"));
                    this.setToolTipText(String.format(Messages.getString("FileTableCellRenderer.NeedUpdateFromMame"), nfo.name));
                    break;
                }
                case NOTFOUND: {
                    this.setForeground(Color.decode("0xcc0000"));
                    this.setToolTipText(String.format(Messages.getString("FileTableCellRenderer.StatusUnknownMameNotFound"), nfo.name));
                    break;
                }
                default: {
                    this.setForeground(Color.black);
                    this.setToolTipText(this.getText());
                    break;
                }
            }
        } else {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setForeground(Color.black);
            if (column > 1) {
                this.setHorizontalAlignment(0);
            } else {
                this.setToolTipText(this.getText());
            }
        }
        this.setBackground(isSelected ? Color.decode("0xBBBBDD") : Color.white);
        return this;
    }
}

