/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.sourceforge.pmd.cpd.ReportException;

public class FileReporter {
    private File reportFile;
    private String encoding;

    public FileReporter(File reportFile) {
        this(reportFile, System.getProperty("file.encoding"));
    }

    public FileReporter(File reportFile, String encoding) {
        if (reportFile == null) {
            throw new NullPointerException("reportFile can not be null");
        }
        this.reportFile = reportFile;
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(String content) throws ReportException {
        try {
            Writer writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.reportFile), this.encoding));
                writer.write(content);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException ioe) {
            throw new ReportException(ioe);
        }
    }
}

