/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.argo.uml.ui;

import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.argouml.application.helpers.ResourceLoaderWrapper;
import org.argouml.kernel.Project;
import org.argouml.kernel.ProjectManager;
import org.argouml.model.Model;
import org.argouml.moduleloader.ModuleInterface;
import org.argouml.ui.ArgoDiagram;
import org.argouml.ui.ProjectBrowser;
import org.argouml.ui.cmd.GenericArgoMenuBar;
import org.dbuml.argo.language.GeneratorSQL;
import org.dbuml.argo.model.ArgoDBModelFacade;
import org.dbuml.argo.uml.diagram.ui.DBDeploymentDiagram;
import org.dbuml.argo.uml.diagram.ui.DBSchemaDiagram;
import org.dbuml.argo.uml.diagram.ui.FigureFactory;
import org.dbuml.argo.uml.ui.DBDeploymentDiagramMenu;
import org.dbuml.argo.uml.ui.DBSchemaDiagramMenu;
import org.dbuml.base.i18n.Translator;

public class DBModule
implements ModuleInterface {
    private static final Logger LOG = Logger.getLogger(DBModule.class);
    private static DBDeploymentDiagramMenu _deployAction = null;
    private static JMenuItem _deployMenu = null;
    private static DBSchemaDiagramMenu _schemaAction = null;
    private static JMenuItem _schemaMenu = null;
    private boolean _initialized = false;

    public boolean enable() {
        GenericArgoMenuBar menubar = (GenericArgoMenuBar)ProjectBrowser.getInstance().getJMenuBar();
        ProjectBrowser.getInstance().setAppName(this.getName());
        if (_schemaMenu == null) {
            _schemaMenu = new JMenuItem("New Database Schema Diagram", ResourceLoaderWrapper.lookupIconResource((String)"DBSchemaDiagram"));
        }
        if (_schemaAction == null) {
            _schemaAction = new DBSchemaDiagramMenu();
        }
        _schemaMenu.addActionListener((ActionListener)((Object)_schemaAction));
        menubar.getTools().add(_schemaMenu);
        if (_deployMenu == null) {
            _deployMenu = new JMenuItem("New Database Deployment Diagram", ResourceLoaderWrapper.lookupIconResource((String)"DBDeploymentDiagram"));
        }
        if (_deployAction == null) {
            _deployAction = new DBDeploymentDiagramMenu();
        }
        _deployMenu.addActionListener((ActionListener)((Object)_deployAction));
        menubar.getTools().add(_deployMenu);
        this.initializeFactories();
        LOG.info((Object)"*** DBUML module initialized");
        this._initialized = true;
        return this._initialized;
    }

    protected void initializeFactories() {
        this.initializeFigureFactory();
        this.initializeDBModelFactory();
        this.initializeTranslator();
        this.initializeGeneratorSQL();
    }

    protected void initializeFigureFactory() {
        FigureFactory.getInstance();
    }

    protected void initializeDBModelFactory() {
        ArgoDBModelFacade.getInstance();
    }

    protected void initializeTranslator() {
        Translator.getInstance();
    }

    protected void initializeGeneratorSQL() {
        GeneratorSQL.getInstance();
    }

    public static void createDefaultDiagrams() {
        Model.getPump().flushModelEvents();
        Model.getPump().stopPumpingEvents();
        Model.getPump().flushModelEvents();
        Project p = ProjectManager.getManager().getCurrentProject();
        p.remove();
        p = ProjectManager.getManager().makeEmptyProject(false);
        Object model = Model.getModelManagementFactory().createModel();
        Model.getCoreHelper().setName(model, "untitledmodel");
        p.setRoot(model);
        p.setCurrentNamespace(model);
        p.addMember(model);
        DBDeploymentDiagram d = new DBDeploymentDiagram(p.getModel());
        p.addDiagram((ArgoDiagram)d);
        p.addDiagram((ArgoDiagram)new DBSchemaDiagram(p.getModel()));
        p.setActiveDiagram((ArgoDiagram)d);
        ProjectManager.getManager().setCurrentProject(p);
        ProjectManager.getManager().setSaveEnabled(false);
    }

    public boolean disable() {
        return true;
    }

    public String getName() {
        return "DB-UML";
    }

    public String getInfo(int type) {
        String info = null;
        switch (type) {
            case 0: {
                info = "SQL UML Modeling";
                break;
            }
            case 1: {
                info = "jgunderson@cincom.com";
                break;
            }
            case 2: {
                info = "1.0.0";
                break;
            }
        }
        return info;
    }
}

