/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.application.windows;

import com.jgoodies.app.gui.application.windows.AbstractWindowModel;
import com.jgoodies.application.Application;
import com.jgoodies.common.swing.internal.AncestorSupport;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.dialogs.basics.BasicVerification;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.PreferredWidth;
import com.jgoodies.dialogs.core.Verification;
import com.jgoodies.dialogs.core.pane.task.TaskPaneBuilder;
import com.jgoodies.framework.util.ScreenUtils;
import com.jgoodies.framework.util.WindowUtils;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;

public abstract class AbstractWindowManager<WM extends AbstractWindowModel> {
    private static final String SECONDARY_WINDOW_COUNT_KEY = "secondaryWindowCount";
    private static final Verification ALWAYS_CLOSE_ALL_WINDOWS = BasicVerification.create("dialogs.dontShowAgain.text", "always_close_all_windows", false);
    private final Preferences rootPrefs;
    private WM primary;
    private final List<WM> secondaries = new ArrayList<WM>();

    public AbstractWindowManager(Preferences rootPrefs) {
        this.rootPrefs = rootPrefs;
    }

    protected abstract WM createSecondaryWindowModel(int var1);

    protected String windowNameFor(int index) {
        return "secondary" + index;
    }

    protected void closeAllWindows(EventObject evt) {
        Application.getInstance().exit(evt);
    }

    protected void onPrimaryWindowClosing(WindowEvent evt) {
        this.closeAllWindows(evt);
    }

    protected void onSecondaryWindowClosing(WindowEvent evt) {
        if (ALWAYS_CLOSE_ALL_WINDOWS.isSelected()) {
            this.closeAllWindows(evt);
            return;
        }
        JCheckBox alwaysCloseAllBox = JGComponentFactory.getCurrent().createCheckBox("_Immer alle schlie\u00dfen");
        String closeAll = "_Alle schlie\u00dfen";
        String closeThis = "_Dieses Fenster schlie\u00dfen";
        Object result = ((TaskPaneBuilder)((TaskPaneBuilder)((TaskPaneBuilder)new TaskPaneBuilder().owner(evt)).title(Application.getResourceMap(null).getString("application.title", new Object[0]), new Object[0])).mainInstructionText("Alle Fenster schlie\u00dfen?", new Object[0]).content(alwaysCloseAllBox).commitCommands(closeAll, closeThis, CommandValue.CANCEL).preferredWidth(PreferredWidth.MEDIUM)).showDialogReturnCommitValue();
        if (result == CommandValue.CANCEL) {
            return;
        }
        ALWAYS_CLOSE_ALL_WINDOWS.setSelected(alwaysCloseAllBox.isSelected());
        if (result == closeAll) {
            this.closeAllWindows(evt);
            return;
        }
        if (result == closeThis) {
            this.onRemoveWindowPerformed(evt);
        }
    }

    public final void onNewWindowPerformed(EventObject evt) {
        WM model = this.createAndAddSecondaryWindow();
        ((AbstractWindowModel)model).initState();
        ((AbstractWindowModel)model).showRelativeTo(AncestorSupport.getWindowFor(evt));
    }

    public final void onRemoveWindowPerformed(EventObject evt) {
        AbstractWindowModel model = (AbstractWindowModel)this.windowModelFor(evt).get();
        model.close();
        this.removeSecondaryWindow(model);
    }

    public final void closeSecondaryWindows() {
        this.storeState();
        for (AbstractWindowModel secondary : this.secondaries) {
            secondary.close();
        }
        this.secondaries.clear();
    }

    public final WM getPrimary() {
        return this.primary;
    }

    public final void setPrimary(WM primaryWindowModel) {
        this.primary = primaryWindowModel;
        ((AbstractWindowModel)this.primary).addWindowClosingListener(this::onPrimaryWindowClosing);
    }

    public final void forEach(Consumer<? super WM> consumer) {
        consumer.accept(this.primary);
        this.secondaries.forEach(consumer);
    }

    public final void storeState() {
        this.forEach(this::storeState0);
        this.applicationPrefs().putInt(SECONDARY_WINDOW_COUNT_KEY, this.secondaries.size());
    }

    private void storeState0(WM windowModel) {
        WindowUtils.storeBounds(this.rootPrefs, ((AbstractWindowModel)windowModel).getWindow());
        ((AbstractWindowModel)windowModel).storeState(this.windowPrefsFor(windowModel));
    }

    public final void restoreState() {
        ((AbstractWindowModel)this.primary).restoreState(this.windowPrefsFor(this.primary));
        int count = this.applicationPrefs().getInt(SECONDARY_WINDOW_COUNT_KEY, 0);
        for (int i = 0; i < count; ++i) {
            WM secondary = this.createAndAddSecondaryWindow();
            ((AbstractWindowModel)secondary).restoreState(this.windowPrefsFor(secondary));
            ((AbstractWindowModel)secondary).show();
        }
    }

    private void clearState(WM model) {
        WindowUtils.clearBounds(this.rootPrefs, ((AbstractWindowModel)model).getWindow());
        WindowUtils.clearState(this.rootPrefs, ((AbstractWindowModel)model).getWindow());
        try {
            this.windowPrefsFor(model).removeNode();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    private WM createAndAddSecondaryWindow() {
        int secondaryWindowIndex = this.getSecondariesSize();
        WM windowModel = this.createSecondaryWindowModel(secondaryWindowIndex);
        ((AbstractWindowModel)windowModel).setName(this.windowNameFor(secondaryWindowIndex));
        ((AbstractWindowModel)windowModel).initContent();
        this.addSecondaryWindow(windowModel);
        return windowModel;
    }

    protected final int getSecondariesSize() {
        return this.secondaries.size();
    }

    protected final void addSecondaryWindow(WM windowModel) {
        this.secondaries.add(windowModel);
    }

    protected final void removeSecondaryWindow(WM windowModel) {
        this.clearState(windowModel);
        this.secondaries.remove(windowModel);
        int index = 0;
        for (AbstractWindowModel secondary : this.secondaries) {
            secondary.setName(this.windowNameFor(index++));
        }
    }

    private Preferences windowPrefsFor(WM model) {
        return this.applicationPrefs().node(((AbstractWindowModel)model).getWindow().getName());
    }

    private Preferences applicationPrefs() {
        return ScreenUtils.screenConfigurationNode(this.rootPrefs);
    }

    private Optional<WM> windowModelFor(EventObject evt) {
        Window window = AncestorSupport.getWindowFor(evt);
        return this.secondaries.stream().filter(model -> model.isWindow(window)).findFirst();
    }
}

