/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.components.JGButton;
import com.jgoodies.components.plaf.ComponentSetup;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class JGHyperlink
extends JGButton {
    public static final String PROPERTY_VISITED = "visited";
    public static final String PROPERTY_VISITED_ENABLED = "visitedEnabled";
    public static final String PROPERTY_ICON_VISIBLE = "iconVisible";
    public static final String PROPERTY_VISITED_FOREGROUND = "visitedForeground";
    private static final String UI_CLASS_ID = "JSDL.HyperlinkUI";
    private boolean visited = false;
    private boolean visitedEnabled = false;
    private Color visitedForeground;
    private boolean iconVisible;

    public JGHyperlink() {
        this(null, "Mandatory Text", false);
    }

    public JGHyperlink(String text) {
        this(null, text, false);
    }

    public JGHyperlink(Icon icon, String text, boolean iconVisible) {
        Preconditions.checkNotBlank(text, "The %s must not be null, empty, or whitespace.", "text");
        this.setModel(new DefaultButtonModel());
        this.setIcon(icon);
        this.setText(text);
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(true);
        this.setIconVisible(iconVisible);
        this.updateUI();
    }

    public JGHyperlink(Action action, boolean iconVisible) {
        Preconditions.checkNotNull(action, "The %s must not be null.", "action");
        String actionName = (String)action.getValue("Name");
        Preconditions.checkNotBlank(actionName, "The %s must not be null, empty, or whitespace.", "action name");
        this.setModel(new DefaultButtonModel());
        this.setAction(action);
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(true);
        this.setIconVisible(iconVisible);
        this.updateUI();
    }

    public boolean isIconVisible() {
        return this.iconVisible;
    }

    public void setIconVisible(boolean newValue) {
        boolean oldValue = this.isIconVisible();
        this.iconVisible = newValue;
        this.firePropertyChange(PROPERTY_ICON_VISIBLE, oldValue, newValue);
        this.revalidate();
        this.repaint();
    }

    public boolean getVisited() {
        return this.visited;
    }

    protected void setVisited(boolean newValue) {
        this.visited = newValue;
        this.firePropertyChange(PROPERTY_VISITED, this.visited, this.visited);
    }

    public boolean isVisitedEnabled() {
        return this.visitedEnabled;
    }

    public void setVisitedEnabled(boolean newValue) {
        this.visitedEnabled = newValue;
        this.firePropertyChange(PROPERTY_VISITED_ENABLED, this.visitedEnabled, this.visitedEnabled);
    }

    public Color getVisitedForeground() {
        return this.visitedForeground;
    }

    public void setVisitedForeground(Color newValue) {
        Color oldValue = this.getVisitedForeground();
        this.visitedForeground = newValue;
        this.firePropertyChange(PROPERTY_VISITED_FOREGROUND, oldValue, newValue);
        this.repaint();
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        boolean oldRollover = this.getModel().isRollover();
        this.getModel().setRollover(false);
        this.setVisited(true);
        super.fireActionPerformed(event);
        this.getModel().setRollover(oldRollover && this.isShowing());
    }

    @Override
    public void setMnemonic(int mnemonic) {
    }

    @Override
    public void setDisplayedMnemonicIndex(int index) {
    }

    @Override
    public void updateUI() {
        ComponentSetup.ensureSetup();
        this.setUI((ButtonUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }
}

