/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components;

import com.jgoodies.binding.adapter.TextComponentConnector;
import com.jgoodies.binding.beans.DelayedPropertyChangeHandler;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.jsdl.internal.MyListeners;
import com.jgoodies.common.swing.focus.FocusTraversalUtils;
import com.jgoodies.components.internal.JGTextComponent;
import com.jgoodies.components.internal.PromptSupport;
import com.jgoodies.components.internal.TextFieldIcons;
import com.jgoodies.components.internal.TextFieldSupport;
import com.jgoodies.components.util.ComponentUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.Objects;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class JGSearchField
extends JTextField
implements JGTextComponent {
    public static final String PROPERTY_SEARCH_TEXT = "searchText";
    public static final String PROPERTY_SEARCH_MODE = "searchMode";
    public static final String PROPERTY_INSTANT_SEARCH_DELAY = "instantSearchDelay";
    private static final Action SEARCH_ACTION = new SearchAction();
    private static final Action CLEAR_ACTION = new ClearAction();
    private final ValueModel textHolder = new ValueHolder();
    private final DelayedPropertyChangeHandler instantSearchHandler;
    private SearchMode searchMode = SearchMode.REGULAR;
    private String searchText = "";

    public JGSearchField() {
        this(SearchMode.INSTANT);
    }

    public JGSearchField(int columns) {
        this(columns, SearchMode.INSTANT);
    }

    public JGSearchField(SearchMode mode) {
        this(0, mode);
    }

    public JGSearchField(int columns, SearchMode mode) {
        super(columns);
        this.instantSearchHandler = MyListeners.delayed(this::onDelayedTextChange);
        this.instantSearchHandler.setCoalesce(true);
        this.setIconVisibleAlways(true);
        this.setSearchMode(mode);
        this.configureSearch();
        this.initEventHandling();
    }

    public String getSearchText() {
        return this.searchText;
    }

    private void setSearchText(String newSearchText) {
        String oldSearchText = this.getSearchText();
        this.searchText = newSearchText;
        this.firePropertyChange(PROPERTY_SEARCH_TEXT, oldSearchText, newSearchText);
    }

    public void resetSearchText() {
        boolean regular;
        this.searchText = "";
        boolean bl = regular = this.searchMode == SearchMode.REGULAR;
        if (this.isEmpty() || regular) {
            this.configureSearch();
        }
    }

    public void search() {
        if (this.isEmpty()) {
            this.configureSearch();
        } else {
            this.configureClear();
        }
        this.setSearchText(this.getText());
    }

    @Override
    public final String getPrompt() {
        return PromptSupport.getPrompt(this);
    }

    @Override
    public final void setPrompt(String prompt) {
        PromptSupport.setPrompt(this, prompt);
    }

    @Override
    public final int getPromptStyle() {
        return PromptSupport.getPromptStyle(this);
    }

    @Override
    public final void setPromptStyle(int style) {
        PromptSupport.setPromptStyle(this, style);
    }

    @Override
    public final boolean isPromptVisibleWhenFocused() {
        return PromptSupport.isPromptVisibleWhenFocused(this);
    }

    @Override
    public final void setPromptVisibleWhenFocused(boolean newValue) {
        PromptSupport.setPromptVisibleWhenFocused(this, newValue);
    }

    @Override
    public final boolean isJGFocusTraversable() {
        return FocusTraversalUtils.isFocusTraversable(this);
    }

    @Override
    public final void setJGFocusTraversable(Boolean value) {
        FocusTraversalUtils.setFocusTraversable(this, value);
    }

    @Override
    public final Boolean getSelectOnFocusGainEnabled() {
        return TextFieldSupport.getSelectOnFocusGainEnabled(this);
    }

    @Override
    public final void setSelectOnFocusGainEnabled(Boolean b) {
        TextFieldSupport.setSelectOnFocusGainEnabled(this, b);
    }

    @Override
    public final void setKeyboardAction(Action keyboardAction) {
        ComponentUtils.registerKeyboardAction(this, keyboardAction);
    }

    public final SearchMode getSearchMode() {
        return this.searchMode;
    }

    public final void setSearchMode(SearchMode newValue) {
        Preconditions.checkNotNull(newValue, "The %s must not be null.", "search mode");
        SearchMode oldValue = this.getSearchMode();
        this.searchMode = newValue;
        boolean regular = this.searchMode == SearchMode.REGULAR;
        this.setButtonPaintedAlways(regular);
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChange(PROPERTY_SEARCH_MODE, (Object)oldValue, (Object)newValue);
        if (this.isEmpty() || regular) {
            this.configureSearch();
        } else {
            this.configureClear();
        }
        if (regular) {
            this.textHolder.removeValueChangeListener(this.instantSearchHandler);
        } else {
            this.textHolder.addValueChangeListener(this.instantSearchHandler);
        }
    }

    public final int getInstantSearchDelay() {
        return this.instantSearchHandler.getDelay();
    }

    public final void setInstantSearchDelay(int newDelay) {
        int oldDelay = this.getInstantSearchDelay();
        if (oldDelay == newDelay) {
            return;
        }
        this.instantSearchHandler.setDelay(newDelay);
        this.firePropertyChange(PROPERTY_INSTANT_SEARCH_DELAY, oldDelay, newDelay);
    }

    public final JPopupMenu getMenu() {
        return TextFieldSupport.getMenu(this);
    }

    public final void setMenu(JPopupMenu popupMenu) {
        TextFieldSupport.setMenu(this, popupMenu);
    }

    @Override
    public Dimension getPreferredSize() {
        return TextFieldSupport.getPreferredSize(this, super.getPreferredSize());
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        return TextFieldSupport.getToolTipText(this, e, super.getToolTipText());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        PromptSupport.paintPrompt(this, g);
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent evt) {
        if (evt.getID() == 401) {
            switch (evt.getKeyCode()) {
                case 10: {
                    if (!this.isRegular() || !this.hasPendingSearch()) break;
                    this.search();
                    evt.consume();
                    break;
                }
                case 27: {
                    if (this.isEmpty()) break;
                    this.clear();
                    evt.consume();
                    break;
                }
            }
        }
        super.processComponentKeyEvent(evt);
    }

    private boolean hasPendingSearch() {
        return !this.getSearchText().equals(this.getText());
    }

    @Override
    public void updateUI() {
        super.updateUI();
        JPopupMenu menu = this.getMenu();
        if (menu != null) {
            menu.updateUI();
        }
        TextFieldSupport.updateUI(this);
    }

    private boolean isEmpty() {
        return Strings.isEmpty(this.getText());
    }

    private boolean isRegular() {
        return this.getSearchMode() == SearchMode.REGULAR;
    }

    private void setIcon(Icon newIcon) {
        TextFieldSupport.setIcon(this, newIcon);
    }

    private void setIconVisibleAlways(boolean newValue) {
        TextFieldSupport.setIconVisibleAlways(this, newValue);
    }

    private void setIconAction(Action iconAction) {
        TextFieldSupport.setIconAction((JTextComponent)this, iconAction);
    }

    private void setButtonPaintedAlways(boolean newValue) {
        TextFieldSupport.setButtonPaintedAlways(this, newValue);
    }

    private void initEventHandling() {
        TextComponentConnector.connect(this.textHolder, this);
        this.textHolder.addValueChangeListener(this::onTextChange);
    }

    private void configureSearch() {
        this.setIcon(TextFieldIcons.getSearchIcon());
        this.setIconAction(this.isRegular() ? SEARCH_ACTION : null);
    }

    private void configureClear() {
        this.setIcon(TextFieldIcons.getClearIcon());
        this.setIconAction(CLEAR_ACTION);
    }

    private void clear() {
        this.setText("");
        this.setSearchText(this.getText());
    }

    private void onTextChange(PropertyChangeEvent evt) {
        if (this.isRegular() || this.isEmpty()) {
            this.configureSearch();
        } else {
            this.configureClear();
        }
    }

    private void onDelayedTextChange(PropertyChangeEvent evt) {
        this.search();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJGSearchField();
        }
        return this.accessibleContext;
    }

    private final class AccessibleJGSearchField
    extends JTextField.AccessibleJTextField {
        private AccessibleJGSearchField() {
            super(JGSearchField.this);
        }

        @Override
        public String getAccessibleName() {
            String name = super.getAccessibleName();
            if (name != null) {
                return name;
            }
            return JGSearchField.this.getPrompt();
        }

        @Override
        public String getAccessibleDescription() {
            String description = super.getAccessibleDescription();
            if (description != null) {
                return description;
            }
            String name = this.getAccessibleName();
            return Objects.equals(name, JGSearchField.this.getPrompt()) ? null : JGSearchField.this.getPrompt();
        }
    }

    private static final class ClearAction
    extends AbstractAction {
        private ClearAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ((JGSearchField)evt.getSource()).clear();
        }
    }

    private static final class SearchAction
    extends AbstractAction {
        private SearchAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JGSearchField source = (JGSearchField)evt.getSource();
            if (source.hasPendingSearch()) {
                source.search();
            }
        }
    }

    public static enum SearchMode {
        INSTANT,
        REGULAR;

    }
}

