/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components;

import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.components.JGSplitButton;
import com.jgoodies.components.internal.ToolBarComponentUtils;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.basic.BasicBorders;

public final class JGToolBarSplitButton
extends JGSplitButton {
    public static final String PROPERTY_SEPARATOR_PAINTED_ALWAYS = "separatorPaintedAlways";
    private boolean separatorPaintedAlways;

    public JGToolBarSplitButton(Action action, JPopupMenu menu) {
        super(action, menu);
        this.configure();
    }

    @Override
    public void setBorder(Border border) {
        if (border == null || border.getClass() != EmptyBorder.class) {
            super.setBorder(border);
            return;
        }
        super.setBorder(new BorderUIResource.CompoundBorderUIResource(border, new BasicBorders.MarginBorder()));
    }

    private void configure() {
        ToolBarComponentUtils.configureButton(this);
        this.setSeparatorPaintedAlways(SystemUtils.IS_OS_MAC);
    }

    @Override
    protected int getPopupPlatformOffsetX() {
        return SystemUtils.IS_OS_MAC && this.getIcon() == null ? 5 : 0;
    }

    @Override
    public boolean isSeparatorPaintedAlways() {
        return this.separatorPaintedAlways;
    }

    public void setSeparatorPaintedAlways(boolean newValue) {
        boolean oldValue = this.isSeparatorPaintedAlways();
        this.separatorPaintedAlways = newValue;
        this.firePropertyChange(PROPERTY_SEPARATOR_PAINTED_ALWAYS, oldValue, newValue);
    }
}

