/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core;

import com.jgoodies.common.swing.MnemonicUtils;
import com.jgoodies.dialogs.core.CoreDialogResources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class CommandValue {
    private static final List<CommandValue> VALUES = new ArrayList<CommandValue>();
    public static final CommandValue OK = CommandValue.create("ok", 1, true);
    public static final CommandValue DONE = CommandValue.create("done", 1, true);
    public static final CommandValue CONTINUE = CommandValue.create("continue", 1, true);
    public static final CommandValue PROCEED_ANYWAY = CommandValue.create("proceed_anyway", 1, true);
    public static final CommandValue RUN_ANYWAY = CommandValue.create("run_anyway", 1, true);
    public static final CommandValue SAVE_ANYWAY = CommandValue.create("save_anyway", 1, true);
    public static final CommandValue YES = CommandValue.create("yes", 1, true);
    public static final CommandValue NO = CommandValue.create("no", 2, true);
    public static final CommandValue IGNORE = CommandValue.create("ignore", 1, true);
    public static final CommandValue RETRY = CommandValue.create("retry", 2, true);
    public static final CommandValue ACCEPT = CommandValue.create("accept", 1, true);
    public static final CommandValue DECLINE = CommandValue.create("decline", 2, true);
    public static final CommandValue DISCARD = CommandValue.create("discard", 2, true);
    public static final CommandValue DONT_DELETE = CommandValue.create("dont_delete", 2, true);
    public static final CommandValue DONT_REMOVE = CommandValue.create("dont_remove", 2, true);
    public static final CommandValue DONT_RUN = CommandValue.create("dont_run", 2, true);
    public static final CommandValue DONT_SAVE = CommandValue.create("dont_save", 2, true);
    public static final CommandValue DONT_UPLOAD = CommandValue.create("dont_upload", 2, true);
    public static final CommandValue CANCEL = CommandValue.create("cancel", 3, true);
    public static final CommandValue APPLY = CommandValue.create("apply", 4);
    public static final CommandValue RUN = CommandValue.create("run", 1);
    public static final CommandValue SAVE = CommandValue.create("save", 1);
    public static final CommandValue SAVE_ALL_CHANGES = CommandValue.create("save_all_changes", 1);
    public static final CommandValue REVIEW_CHANGES = CommandValue.create("review_changes", 1);
    public static final CommandValue UPLOAD = CommandValue.create("upload", 1);
    public static final CommandValue START = CommandValue.create("start", 2);
    public static final CommandValue DISCARD_CHANGES = CommandValue.create("discard_changes", 2);
    public static final CommandValue CLOSE = CommandValue.create("close", 3);
    public static final CommandValue STOP = CommandValue.create("stop", 3);
    public static final CommandValue HELP = CommandValue.create("help", 5);
    public static final CommandValue ABOUT = CommandValue.create("about");
    public static final CommandValue ADD = CommandValue.create("add");
    public static final CommandValue BROWSE = CommandValue.create("browse");
    public static final CommandValue CLEAR = CommandValue.create("clear");
    public static final CommandValue CONNECT = CommandValue.create("connect");
    public static final CommandValue COPY = CommandValue.create("copy");
    public static final CommandValue DELETE = CommandValue.create("delete");
    public static final CommandValue DISCONNECT = CommandValue.create("disconnect");
    public static final CommandValue DISCARD_ALL_CHANGES = CommandValue.create("discard_all_changes");
    public static final CommandValue EDIT = CommandValue.create("edit");
    public static final CommandValue EXIT = CommandValue.create("exit");
    public static final CommandValue FIND = CommandValue.create("find");
    public static final CommandValue FINISH = CommandValue.create("finish");
    public static final CommandValue INSERT = CommandValue.create("insert");
    public static final CommandValue INSTALL = CommandValue.create("install");
    public static final CommandValue LOGIN = CommandValue.create("login");
    public static final CommandValue LOGOFF = CommandValue.create("logoff");
    public static final CommandValue MOVE_DOWN = CommandValue.create("move_down");
    public static final CommandValue MOVE_UP = CommandValue.create("move_up");
    public static final CommandValue NEW = CommandValue.create("new");
    public static final CommandValue OPEN = CommandValue.create("open");
    public static final CommandValue PRINT = CommandValue.create("print");
    public static final CommandValue PROCEED = CommandValue.create("proceed");
    public static final CommandValue PROPERTIES = CommandValue.create("properties");
    public static final CommandValue REDO = CommandValue.create("redo");
    public static final CommandValue REPEAT = CommandValue.create("repeat");
    public static final CommandValue REPLACE = CommandValue.create("replace");
    public static final CommandValue RESOLVE = CommandValue.create("resolve");
    public static final CommandValue RESTORE = CommandValue.create("restore");
    public static final CommandValue RESUME = CommandValue.create("resume");
    public static final CommandValue REMOVE = CommandValue.create("remove");
    public static final CommandValue SEARCH = CommandValue.create("search");
    public static final CommandValue SEND = CommandValue.create("send");
    public static final CommandValue SHOW = CommandValue.create("show");
    public static final CommandValue SKIP = CommandValue.create("skip");
    public static final CommandValue UNDO = CommandValue.create("undo");
    public static final CommandValue BACK = CommandValue.create("back");
    public static final CommandValue NEXT = CommandValue.create("next");
    public static final CommandValue PAUSE = CommandValue.create("pause");
    private final String textKey;
    private final int group;
    private final boolean commitOnly;

    protected CommandValue(String textKey) {
        this(textKey, -1);
    }

    protected CommandValue(String textKey, int group) {
        this(textKey, group, false);
    }

    protected CommandValue(String textKey, int group, boolean commitOnly) {
        this.textKey = textKey;
        this.group = group;
        this.commitOnly = commitOnly;
    }

    private static CommandValue create(String keySuffix) {
        CommandValue value = new CommandValue("common." + keySuffix);
        VALUES.add(value);
        return value;
    }

    private static CommandValue create(String keySuffix, int group) {
        CommandValue value = new CommandValue("common." + keySuffix, group);
        VALUES.add(value);
        return value;
    }

    private static CommandValue create(String keySuffix, int group, boolean commitOnly) {
        CommandValue value = new CommandValue("common." + keySuffix, group, commitOnly);
        VALUES.add(value);
        return value;
    }

    public static List<CommandValue> values() {
        return Collections.unmodifiableList(VALUES);
    }

    public final String getText() {
        return this.getText(Locale.getDefault());
    }

    public final String getText(Locale locale) {
        return MnemonicUtils.plainText(this.getMarkedText(locale));
    }

    public final String getMarkedText() {
        return this.getMarkedText(Locale.getDefault());
    }

    public final String getMarkedText(Locale locale) {
        return this.toDisplayString(this.textKey, locale);
    }

    public final int getGroup() {
        return this.group;
    }

    public final boolean isCommitOnly() {
        return this.commitOnly;
    }

    protected String toDisplayString(String key, Locale locale) {
        return CoreDialogResources.getString(key, locale);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append("[");
        this.buildParamString(builder);
        builder.append("]");
        return builder.toString();
    }

    protected void buildParamString(StringBuilder builder) {
        builder.append("textKey=");
        builder.append(this.textKey);
        builder.append("; group=");
        builder.append(this.group);
        builder.append("; commit only=");
        builder.append(this.commitOnly);
    }
}

