/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.tiles;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.common.jsdl.internal.VisibilityUtils;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.fluent.internal.FluentResources;
import com.jgoodies.fluent.internal.IFluentResources;
import com.jgoodies.fluent.internal.Releasable;
import com.jgoodies.fluent.tiles.AbstractTile;
import com.jgoodies.fluent.tiles.Tile;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.factories.Forms;
import com.jgoodies.layout.layout.CellConstraints;
import com.jgoodies.navigation.views.View;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public abstract class AbstractTileView<T extends AbstractTile>
implements View,
Releasable {
    private static final String TILE_KEY = "jgoodies.tile";
    protected final T tile;
    protected final IFluentResources resources;
    protected JLabel nameLabel;
    protected JLabel logoLabel;
    protected JLabel badgeLabel;
    protected JPanel panel;
    protected ActiveLineBorder outerBorder;
    private final PropertyChangeListener tilePropertyChangeListener;

    protected AbstractTileView(T tile) {
        this.tile = (AbstractTile)Preconditions.checkNotNull(tile, "The %s must not be null.", "tile");
        this.resources = FluentResources.getInstance();
        this.tilePropertyChangeListener = this::onTilePropertyChanged;
        this.initComponents();
        this.initEventHandling();
    }

    public static Tile getTileFor(InputEvent evt) {
        Object value;
        Object source = evt.getSource();
        if (source instanceof JPanel && (value = ((JPanel)source).getClientProperty(TILE_KEY)) instanceof Tile) {
            return (Tile)value;
        }
        return null;
    }

    protected void initComponents() {
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        this.nameLabel = factory.createLabel();
        this.nameLabel.setFont(this.getBaseFont());
        this.logoLabel = new JLabel();
        this.badgeLabel = new JLabel();
        this.badgeLabel.setFont(this.getBaseFont());
        this.badgeLabel.setForeground(((AbstractTile)this.tile).getForeground());
        this.panel = new JPanel(null);
        this.panel.putClientProperty(TILE_KEY, this.tile);
        this.outerBorder = new ActiveLineBorder(((AbstractTile)this.tile).getBackground(), 2);
    }

    private void initEventHandling() {
        ((Bean)this.tile).addPropertyChangeListener(this.tilePropertyChangeListener);
        this.panel.addMouseListener(new MouseHandler());
    }

    public final T getTile() {
        return this.tile;
    }

    @Override
    public JPanel getPanel() {
        if (this.panel.getComponentCount() == 0) {
            this.onTilePropertyChanged(null);
            this.build();
        }
        return this.panel;
    }

    protected JComponent buildBrandingBar() {
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("left:0:grow, 2epx, pref, 0dlu, pref", new Object[0])).rows("bottom:p", new Object[0])).add(this.nameVisible(), this.nameLabel).xy(1, 1)).add(this.logoInBrandingBar(), this.logoLabel).at(new CellConstraints(3, 1, 1, 1, CellConstraints.CENTER, CellConstraints.CENTER, AbstractTileView.brandingBarLogoInsets()))).add(this.badgeVisible(), this.paddedBadge()).xy(5, 1)).build();
    }

    protected abstract JComponent build();

    protected abstract boolean contentSet();

    @Override
    public void release() {
        ((Bean)this.tile).removePropertyChangeListener(this.tilePropertyChangeListener);
    }

    protected void onTilePropertyChanged(PropertyChangeEvent evt) {
        if (AbstractTileView.matches(evt, "background")) {
            this.panel.setBackground(((AbstractTile)this.tile).getBackground());
            this.outerBorder.setLineColor(((AbstractTile)this.tile).getBackground());
        }
        if (AbstractTileView.matches(evt, "logo", "foreground")) {
            if (((AbstractTile)this.tile).getLogo() != null) {
                this.logoLabel.setIcon(((AbstractTile)this.tile).getLogo().toIcon(this.getEffectiveLogoSize(), ((AbstractTile)this.tile).getForeground()));
                this.logoLabel.setVisible(true);
            } else {
                this.logoLabel.setVisible(false);
            }
        }
        if (AbstractTileView.matches(evt, "name", "foreground")) {
            VisibilityUtils.setTextAndVisibilityAndForeground(this.nameLabel, ((AbstractTile)this.tile).getName(), ((AbstractTile)this.tile).getForeground());
        }
    }

    protected Font getTitleFont() {
        return this.resources.getTileTitleFont();
    }

    protected Font getBaseFont() {
        return this.resources.getTileBaseFont();
    }

    protected int getEffectiveLogoSize() {
        return 32;
    }

    protected Color lighter(Color value) {
        return AbstractTileView.getSlightlyBrighter(value, 1.3f);
    }

    protected final boolean nameVisible() {
        return ((AbstractTile)this.getTile()).getBranding() == AbstractTile.Branding.NAME || ((AbstractTile)this.getTile()).getBranding() == AbstractTile.Branding.NAME_AND_LOGO;
    }

    protected final boolean badgeVisible() {
        return Strings.isNotBlank(((AbstractTile)this.getTile()).getBadge().displayString());
    }

    protected final boolean logoVisible() {
        return ((AbstractTile)this.getTile()).getBranding() == AbstractTile.Branding.LOGO || ((AbstractTile)this.getTile()).getBranding() == AbstractTile.Branding.NAME_AND_LOGO;
    }

    protected final boolean logoInContent() {
        return this.logoVisible() && !this.contentSet();
    }

    protected final boolean logoInBrandingBar() {
        return this.logoVisible() && this.contentSet();
    }

    protected static Color getSlightlyBrighter(Color color, float factor) {
        float[] hsbValues = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbValues);
        float hue = hsbValues[0];
        float saturation = hsbValues[1];
        float brightness = hsbValues[2];
        float newBrightness = Math.min(brightness * factor, 1.0f);
        return Color.getHSBColor(hue, saturation, newBrightness);
    }

    private static Insets brandingBarLogoInsets() {
        return ScreenScaling.physicalInsets(0, 0, 0, 0);
    }

    private JComponent paddedBadge() {
        return Forms.padded(this.badgeLabel, "0, 3epx, 0, 0", new Object[0]);
    }

    protected static boolean matches(PropertyChangeEvent evt, String ... propertyNames) {
        Preconditions.checkNotNullOrEmpty(propertyNames, "The %s must not be null or empty.");
        if (evt == null) {
            return true;
        }
        String propertyName = evt.getPropertyName();
        if (propertyName == null) {
            return true;
        }
        for (String name : propertyNames) {
            if (!propertyName.equals(name)) continue;
            return true;
        }
        return false;
    }

    private static final class ActiveLineBorder
    extends LineBorder {
        ActiveLineBorder(Color lineColor, int thickness) {
            super(lineColor, thickness);
        }

        void setLineColor(Color value) {
            this.lineColor = value;
        }
    }

    final class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            AbstractTileView.this.outerBorder.setLineColor(AbstractTileView.this.lighter(((AbstractTile)AbstractTileView.this.tile).getBackground()));
            AbstractTileView.this.getPanel().repaint();
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            AbstractTileView.this.outerBorder.setLineColor(((AbstractTile)AbstractTileView.this.tile).getBackground());
            AbstractTileView.this.getPanel().repaint();
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            if (evt.isPopupTrigger()) {
                this.onContextMenuRequested(evt);
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            if (evt.isPopupTrigger()) {
                this.onContextMenuRequested(evt);
                return;
            }
            if (((AbstractTile)AbstractTileView.this.tile).getOnAction() != null) {
                ActionEvent actionEvent = new ActionEvent(evt.getSource(), evt.getID(), "TileClick", evt.getWhen(), evt.getModifiers());
                ((AbstractTile)AbstractTileView.this.tile).getOnAction().accept(actionEvent);
            }
        }

        private void onContextMenuRequested(MouseEvent evt) {
            if (((AbstractTile)AbstractTileView.this.tile).getOnContextMenu() != null) {
                ((AbstractTile)AbstractTileView.this.tile).getOnContextMenu().accept(evt);
            }
        }
    }
}

