/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.application;

import com.jgoodies.application.AbstractInputBlocker;
import com.jgoodies.application.Application;
import com.jgoodies.application.BlockingScope;
import com.jgoodies.application.Task;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;

public class GlassPaneBlocker
extends AbstractInputBlocker {
    private static final String OLD_GLASS_PANE_KEY = "GlassPaneBlocker.oldGlassPane";
    private static final String OLD_GLASS_PANE_VISIBLE_KEY = "GlassPaneBlocker.oldGlassPane.visible";

    @Override
    protected void block(Task<?, ?> task, Window window, int oldCounter) {
        this.logBlock(task, BlockingScope.WINDOW, window);
        if (window instanceof RootPaneContainer) {
            GlassPaneBlocker.block((RootPaneContainer)((Object)window), oldCounter);
        }
    }

    @Override
    protected void block(Task<?, ?> task, Application application, int oldCounter) {
        for (Frame frame : Frame.getFrames()) {
            if (frame instanceof RootPaneContainer) {
                GlassPaneBlocker.block((RootPaneContainer)((Object)frame), oldCounter);
            }
            for (Window window : frame.getOwnedWindows()) {
                if (!(window instanceof RootPaneContainer)) continue;
                int oldWindowCounter = GlassPaneBlocker.increaseBlockingCounter(window);
                GlassPaneBlocker.block((RootPaneContainer)((Object)window), oldWindowCounter);
            }
        }
    }

    @Override
    protected void unblock(Task<?, ?> task, Window window, int newCounter) {
        this.logUnblock(task, BlockingScope.WINDOW, window);
        if (window instanceof RootPaneContainer) {
            GlassPaneBlocker.unblock((RootPaneContainer)((Object)window), newCounter);
        }
    }

    @Override
    protected void unblock(Task<?, ?> task, Application application, int newCounter) {
        for (Frame frame : Frame.getFrames()) {
            if (frame instanceof RootPaneContainer) {
                GlassPaneBlocker.unblock((RootPaneContainer)((Object)frame), newCounter);
            }
            for (Window window : frame.getOwnedWindows()) {
                if (!(window instanceof RootPaneContainer)) continue;
                int newWindowCounter = GlassPaneBlocker.decreaseBlockingCounter(window);
                GlassPaneBlocker.unblock((RootPaneContainer)((Object)window), newWindowCounter);
            }
        }
    }

    private static void block(RootPaneContainer c, int oldCounter) {
        JRootPane rootPane = c.getRootPane();
        if (oldCounter == 0) {
            Component oldGlassPane = c.getGlassPane();
            rootPane.putClientProperty(OLD_GLASS_PANE_KEY, oldGlassPane);
            rootPane.putClientProperty(OLD_GLASS_PANE_VISIBLE_KEY, oldGlassPane.isVisible());
            BlockingGlassPane blockingGlassPane = new BlockingGlassPane();
            c.setGlassPane(blockingGlassPane);
            ((JComponent)blockingGlassPane).setVisible(true);
        }
    }

    private static void unblock(RootPaneContainer c, int newCounter) {
        JRootPane rootPane = c.getRootPane();
        if (newCounter == 0) {
            Component glassPane = c.getGlassPane();
            if (glassPane instanceof BlockingGlassPane) {
                glassPane.setVisible(false);
            }
            Component oldGlassPane = (Component)rootPane.getClientProperty(OLD_GLASS_PANE_KEY);
            Boolean oldGlassPaneVisible = (Boolean)rootPane.getClientProperty(OLD_GLASS_PANE_VISIBLE_KEY);
            c.setGlassPane(oldGlassPane);
            oldGlassPane.setVisible(oldGlassPaneVisible);
        }
    }

    static final class BlockingGlassPane
    extends JComponent {
        private static final KeyEventDispatcher BLOCKING_DISPATCHER = new BlockingKeyEventDispatcher();
        private static final long EVENT_MASK = 131120L;

        BlockingGlassPane() {
            this.setOpaque(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.enableEvents(131120L);
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(BLOCKING_DISPATCHER);
            } else {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(BLOCKING_DISPATCHER);
            }
            super.setVisible(visible);
        }

        private static final class BlockingKeyEventDispatcher
        implements KeyEventDispatcher {
            private BlockingKeyEventDispatcher() {
            }

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                Object source = e.getSource();
                if (!(source instanceof JComponent)) {
                    return false;
                }
                JRootPane rootPane = ((JComponent)source).getRootPane();
                if (rootPane == null) {
                    return false;
                }
                Component glassPane = rootPane.getGlassPane();
                return glassPane instanceof BlockingGlassPane && glassPane.isVisible();
            }
        }
    }
}

