/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.util;

import com.jgoodies.common.base.Preconditions;
import java.awt.Font;
import java.util.Enumeration;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public final class FontSizeUtils {
    private FontSizeUtils() {
    }

    public static void installLargerFonts(float sizeFactor) {
        String key;
        Preconditions.checkArgument(sizeFactor > 0.0f, "The size factor must be positive.");
        if (sizeFactor == 1.0f) {
            return;
        }
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration keys = defaults.keys();
        while (keys.hasMoreElements()) {
            Font font;
            key = keys.nextElement();
            Object value = defaults.get(key);
            if (!(value instanceof Font) || (font = UIManager.getFont(key)) == null) continue;
            float size = font.getSize2D();
            FontUIResource f = new FontUIResource(font.deriveFont(size * sizeFactor));
            UIManager.put(key, f);
        }
        key = "Tree.rowHeight";
        int rowHeight = defaults.getInt(key);
        if (rowHeight != 0) {
            int scaledRowHeight = (int)((float)rowHeight * sizeFactor);
            UIManager.put(key, scaledRowHeight);
        }
    }
}

