/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compressor;

import com.izforge.izpack.compiler.Compiler;
import com.izforge.izpack.compressor.PackCompressor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;

public abstract class PackCompressorBase
implements PackCompressor {
    protected String[] formatNames = null;
    protected String[] containerPaths = null;
    protected String decoderMapper = null;
    protected String[][] decoderClassNames = null;
    protected String encoderClassName = null;
    protected Class[] paramsClasses = null;
    private Compiler compiler;
    private Constructor<Object> constructor;
    private int level = -1;

    public String[] getContainerPaths() {
        return this.containerPaths;
    }

    public String getEncoderClassName() {
        return this.encoderClassName;
    }

    public String[][] getDecoderClassNames() {
        return this.decoderClassNames;
    }

    public boolean useStandardCompression() {
        return false;
    }

    public String[] getCompressionFormatSymbols() {
        return this.formatNames;
    }

    public String getDecoderMapperName() {
        return this.decoderMapper;
    }

    public void setCompiler(Compiler compiler) {
        this.compiler = compiler;
    }

    public void setCompressionLevel(int n) {
        this.level = n;
    }

    public int getCompressionLevel() {
        return this.level;
    }

    public boolean needsBufferedOutputStream() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadClass(String string) throws Exception {
        if (this.getEncoderClassName() == null) {
            return;
        }
        Class<?> clazz = null;
        if (this.getContainerPaths() == null) {
            clazz = Class.forName(string);
        }
        if (clazz == null) {
            Object object;
            int n;
            String[] stringArray = this.getContainerPaths();
            URL[] uRLArray = new URL[stringArray.length];
            Object var5_5 = null;
            int n2 = 0;
            for (n = 0; n < stringArray.length; ++n) {
                URL uRL;
                if (stringArray[n] == null || (uRL = this.compiler.findIzPackResource((String)(object = this.compiler.replaceProperties(stringArray[n])), "Pack compressor jar file")) == null) continue;
                uRLArray[n2++] = uRL;
                if (this.getClass().getResource("/" + (String)object) == null) continue;
                InputStream inputStream = null;
                FileOutputStream fileOutputStream = null;
                byte[] byArray = new byte[5120];
                File file = null;
                try {
                    int n3;
                    file = File.createTempFile("izpj", ".jar");
                    file.deleteOnExit();
                    fileOutputStream = new FileOutputStream(file);
                    inputStream = this.getClass().getResourceAsStream("/" + (String)object);
                    long l = 0L;
                    while ((n3 = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n3);
                        l += (long)n3;
                    }
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                uRL = file.toURL();
            }
            if (n2 > 0) {
                if (n2 < uRLArray.length) {
                    object = new URL[n2];
                    for (n = 0; n < n2; ++n) {
                        object[n] = uRLArray[n];
                    }
                    uRLArray = object;
                }
                object = new URLClassLoader(uRLArray, PackCompressor.class.getClassLoader());
                clazz = ((ClassLoader)object).loadClass(string);
            }
        }
        if (clazz != null) {
            this.constructor = clazz.getDeclaredConstructor(this.paramsClasses);
        } else {
            this.compiler.parseError("Cannot find defined compressor " + string);
        }
    }

    protected OutputStream getOutputInstance(OutputStream outputStream) throws Exception {
        if (this.needsBufferedOutputStream()) {
            outputStream = new BufferedOutputStream(outputStream);
        }
        Object[] objectArray = this.resolveConstructorParams(outputStream);
        if (this.constructor == null) {
            this.loadClass(this.getEncoderClassName());
        }
        if (this.constructor == null) {
            return null;
        }
        Object object = null;
        object = this.constructor.newInstance(objectArray);
        if (!OutputStream.class.isInstance(object)) {
            this.compiler.parseError("'" + this.getEncoderClassName() + "' must be derived from " + OutputStream.class.toString());
        }
        return (OutputStream)object;
    }

    protected Object[] resolveConstructorParams(OutputStream outputStream) throws Exception {
        if (this.level == -1) {
            this.paramsClasses = new Class[1];
            this.paramsClasses[0] = Class.forName("java.io.OutputStream");
            Object[] objectArray = new Object[]{outputStream};
            return objectArray;
        }
        this.paramsClasses = new Class[2];
        this.paramsClasses[0] = Class.forName("java.io.OutputStream");
        this.paramsClasses[1] = Integer.TYPE;
        Object[] objectArray = new Object[]{outputStream, this.level};
        return objectArray;
    }
}

