/*
 * Decompiled with CFR 0.152.
 */
package gmgen.io;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class SimpleFileFilter
extends FileFilter {
    private String description;
    private String[] extensions;

    public SimpleFileFilter(String ext) {
        this(new String[]{ext}, null);
    }

    public SimpleFileFilter(String[] exts, String desc) {
        this.extensions = new String[exts.length];
        for (int i = exts.length - 1; i >= 0; --i) {
            this.extensions[i] = exts[i].toLowerCase();
        }
        String workingDesc = desc == null ? "Unknown File" : desc;
        StringBuilder strbDesc = new StringBuilder(workingDesc + " (");
        for (int i = 0; i < this.extensions.length; ++i) {
            if (i > 0) {
                strbDesc.append(", ");
            }
            strbDesc.append("*." + this.extensions[i]);
        }
        strbDesc.append(")");
        this.description = strbDesc.toString();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String name = f.getName().toLowerCase();
        for (int i = this.extensions.length - 1; i >= 0; --i) {
            if (!name.endsWith(this.extensions[i])) continue;
            return true;
        }
        return false;
    }
}

