/*
 * Decompiled with CFR 0.152.
 */
package gmgen.io;

import java.util.AbstractList;
import java.util.Vector;

public class VectorTable
extends AbstractList {
    private String name;
    private Vector header;
    private Vector rows;

    public VectorTable(String s) {
        this.name = s;
        this.rows = new Vector();
        this.header = new Vector();
    }

    public VectorTable() {
        this("");
    }

    @Override
    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean add(Object o) {
        if (o instanceof Vector) {
            if (((Vector)o).isEmpty()) {
                return false;
            }
            this.header.add(((Vector)o).firstElement());
            this.rows.add(o);
            return true;
        }
        return false;
    }

    public Object backReferenceForX(Object Y, Object Z) {
        int x;
        if (this.rows.isEmpty()) {
            return null;
        }
        int y = ((Vector)this.rows.firstElement()).indexOf(Y);
        try {
            x = ((Vector)this.rows.elementAt(y)).indexOf(Z);
        }
        catch (Exception e) {
            return null;
        }
        try {
            return ((Vector)this.rows.elementAt(y)).elementAt(x);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void clear() {
        for (int x = this.rows.size() - 1; x >= 0; --x) {
            try {
                ((Vector)this.rows.elementAt(x)).clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rows.clear();
        }
    }

    @Override
    public boolean contains(Object o) {
        boolean found = false;
        if (this.rows.contains(o)) {
            return true;
        }
        for (int x = this.rows.size() - 1; x >= 0; --x) {
            try {
                if (!((Vector)this.rows.elementAt(x)).contains(o)) continue;
                found = true;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return found;
    }

    public Object crossReference(Object X, Object Y) {
        Vector v;
        if (this.rows.isEmpty()) {
            return null;
        }
        if (this.header.isEmpty()) {
            return null;
        }
        int x = ((Vector)this.rows.firstElement()).indexOf(Y);
        int y = this.header.indexOf(X);
        try {
            v = (Vector)this.rows.elementAt(y);
        }
        catch (Exception e) {
            return null;
        }
        try {
            return v.elementAt(x);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object elementAt(int index) {
        return this.rows.elementAt(index);
    }

    public Object elementAt(int x, int y) throws ArrayIndexOutOfBoundsException {
        return ((Vector)this.rows.elementAt(x)).elementAt(y);
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o.toString().equals(this.name);
    }

    @Override
    public Object get(int index) {
        return this.rows.get(index);
    }

    @Override
    public int hashCode() {
        return this.rows.hashCode();
    }

    @Override
    public boolean remove(Object o) {
        boolean success = false;
        if (this.contains(o)) {
            if (this.rows.contains(o)) {
                this.rows.remove(o);
                success = true;
            } else {
                for (int x = this.rows.size() - 1; x >= 0; --x) {
                    try {
                        if (!((Vector)this.rows.elementAt(x)).contains(o)) continue;
                        ((Vector)this.rows.elementAt(x)).remove(o);
                        success = true;
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        return success;
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    public int sizeX() {
        return ((Vector)this.header.firstElement()).size();
    }

    public int sizeY() {
        return this.rows.size();
    }

    @Override
    public Object[] toArray() {
        return this.rows.toArray();
    }

    public Object[] toArray(int x) {
        if (this.rows.isEmpty()) {
            return null;
        }
        return ((Vector)this.rows.elementAt(x)).toArray();
    }

    @Override
    public String toString() {
        return this.name;
    }
}

