/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content;

import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCClass;

public class LevelExchange
extends ConcretePrereqObject {
    private final CDOMSingleRef<PCClass> exchangeClass;
    private final int minDonatingLevel;
    private final int maxDonatedLevels;
    private final int donatingLowerLevelBound;

    public LevelExchange(CDOMSingleRef<PCClass> pcc, int minDonatingLvl, int maxDonated, int donatingLowerBound) {
        if (pcc == null) {
            throw new IllegalArgumentException("Error: Exchange Class must not be null");
        }
        if (minDonatingLvl <= 0) {
            throw new IllegalArgumentException("Error: Min Donating Level <= 0: Cannot Allow Donations to produce negative levels");
        }
        if (maxDonated <= 0) {
            throw new IllegalArgumentException("Error: Max Donated Levels <= 0: Cannot Allow Donations to produce negative levels");
        }
        if (donatingLowerBound < 0) {
            throw new IllegalArgumentException("Error: Max Remaining Levels < 0: Cannot Allow Donations to produce negative levels");
        }
        if (minDonatingLvl - maxDonated > donatingLowerBound) {
            throw new IllegalArgumentException("Error: Donating Lower Bound cannot be reached");
        }
        this.exchangeClass = pcc;
        this.minDonatingLevel = minDonatingLvl;
        this.maxDonatedLevels = maxDonated;
        this.donatingLowerLevelBound = donatingLowerBound;
    }

    public int getDonatingLowerLevelBound() {
        return this.donatingLowerLevelBound;
    }

    public CDOMSingleRef<PCClass> getExchangeClass() {
        return this.exchangeClass;
    }

    public int getMaxDonatedLevels() {
        return this.maxDonatedLevels;
    }

    public int getMinDonatingLevel() {
        return this.minDonatingLevel;
    }

    public int hashCode() {
        return this.minDonatingLevel * 23 + this.maxDonatedLevels * 31 + this.donatingLowerLevelBound;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LevelExchange)) {
            return false;
        }
        LevelExchange other = (LevelExchange)obj;
        return this.minDonatingLevel == other.minDonatingLevel && this.maxDonatedLevels == other.maxDonatedLevels && this.donatingLowerLevelBound == other.donatingLowerLevelBound && this.exchangeClass.equals(other.exchangeClass);
    }
}

