/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.base;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import pcgen.base.util.WrappedMapSet;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.base.AbstractDataFacet;

public abstract class AbstractItemConvertingFacet<S, D>
extends AbstractDataFacet<CharID, D> {
    public void add(CharID id, S obj, Object source) {
        if (obj == null) {
            throw new IllegalArgumentException("Object to add may not be null");
        }
        Target target = this.getConstructingCachedSetFor(id, obj);
        target.set.add(source);
        if (target.dest == null) {
            target.dest = this.convert(obj);
            this.fireDataFacetChangeEvent(id, target.dest, 0);
        }
    }

    public void addAll(CharID id, Collection<? extends S> c, Object source) {
        for (S obj : c) {
            this.add(id, obj, source);
        }
    }

    public void remove(CharID id, S obj, Object source) {
        Map<S, Target> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            this.processRemoval(id, componentMap, obj, source);
        }
    }

    public void removeAll(CharID id, Collection<S> c, Object source) {
        Map<S, Target> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            for (S obj : c) {
                this.processRemoval(id, componentMap, obj, source);
            }
        }
    }

    public Map<S, Target> removeAll(CharID id) {
        Map<S, Target> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return Collections.emptyMap();
        }
        this.removeCache(id);
        for (Target tgt : componentMap.values()) {
            this.fireDataFacetChangeEvent(id, tgt.dest, 1);
        }
        return componentMap;
    }

    public int getCount(CharID id) {
        Map<S, Target> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return 0;
        }
        return componentMap.size();
    }

    public boolean isEmpty(CharID id) {
        Map<S, Target> componentMap = this.getCachedMap(id);
        return componentMap == null || componentMap.isEmpty();
    }

    public boolean contains(CharID id, S obj) {
        Map<S, Target> componentMap = this.getCachedMap(id);
        return componentMap != null && componentMap.containsKey(obj);
    }

    private Target getConstructingCachedSetFor(CharID id, S obj) {
        Map<S, Target> map = this.getConstructingCachedMap(id);
        Target target = map.get(obj);
        if (target == null) {
            target = new Target();
            map.put(obj, target);
        }
        return target;
    }

    protected Map<S, Target> getCachedMap(CharID id) {
        return (Map)this.getCache(id);
    }

    private Map<S, Target> getConstructingCachedMap(CharID id) {
        Map<S, Target> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            componentMap = this.getComponentMap();
            this.setCache(id, componentMap);
        }
        return componentMap;
    }

    protected Map<S, Target> getComponentMap() {
        return new IdentityHashMap();
    }

    @Override
    public void copyContents(CharID source, CharID destination) {
        Map<S, Target> sourceMap = this.getCachedMap(source);
        if (sourceMap != null) {
            for (Map.Entry<S, Target> me : sourceMap.entrySet()) {
                Target origTarget = me.getValue();
                if (origTarget == null) continue;
                S obj = me.getKey();
                Target target = this.getConstructingCachedSetFor(destination, obj);
                target.dest = origTarget.dest;
                target.set.addAll(origTarget.set);
            }
        }
    }

    private void processRemoval(CharID id, Map<S, Target> componentMap, S obj, Object source) {
        if (obj == null) {
            throw new IllegalArgumentException("Object to remove may not be null");
        }
        Target target = componentMap.get(obj);
        if (target != null) {
            target.set.remove(source);
            if (target.set.isEmpty()) {
                componentMap.remove(obj);
                this.fireDataFacetChangeEvent(id, target.dest, 1);
            }
        }
    }

    public void removeAll(CharID id, Object source) {
        Map<S, Target> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            Iterator<Target> it = componentMap.values().iterator();
            while (it.hasNext()) {
                Target target = it.next();
                if (target == null || !target.set.remove(source) || !target.set.isEmpty()) continue;
                it.remove();
                this.fireDataFacetChangeEvent(id, target.dest, 1);
            }
        }
    }

    public boolean containsFrom(CharID id, Object source) {
        Map<S, Target> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            for (Map.Entry<S, Target> me : componentMap.entrySet()) {
                Target target = me.getValue();
                if (target == null || !target.set.contains(source)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract D convert(S var1);

    public Collection<S> getSourceObjects(CharID id) {
        WrappedMapSet set = new WrappedMapSet(IdentityHashMap.class);
        Map<S, Target> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            set.addAll(componentMap.keySet());
        }
        return set;
    }

    public D getResultFor(CharID id, S obj) {
        Map<S, Target> componentMap = this.getCachedMap(id);
        return componentMap == null ? null : (D)componentMap.get(obj).dest;
    }

    public Collection<Object> getSourcesFor(CharID id, S obj) {
        Map<S, Target> componentMap = this.getCachedMap(id);
        WrappedMapSet set = new WrappedMapSet(IdentityHashMap.class);
        if (componentMap == null) {
            return set;
        }
        set.addAll(componentMap.get(obj).set);
        return set;
    }

    private class Target {
        public Set<Object> set = new WrappedMapSet(IdentityHashMap.class);
        public D dest;

        private Target() {
        }

        public int hashCode() {
            return this.dest.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Target) {
                Target other = (Target)o;
                return this.dest.equals(other.dest) && this.set.equals(other.set);
            }
            return false;
        }
    }
}

