/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import pcgen.cdom.base.PCGenIdentifier;
import pcgen.cdom.facet.base.AbstractDataFacet;

public abstract class AbstractListFacet<IDT extends PCGenIdentifier, T>
extends AbstractDataFacet<IDT, T> {
    public boolean add(IDT id, T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Object to add may not be null");
        }
        if (this.getConstructingCachedSet(id).add(obj)) {
            this.fireDataFacetChangeEvent(id, obj, 0);
            return true;
        }
        return false;
    }

    public void addAll(IDT id, Collection<T> c) {
        if (c.isEmpty()) {
            return;
        }
        Collection<T> set = this.getConstructingCachedSet(id);
        for (T obj : c) {
            if (obj == null) {
                throw new IllegalArgumentException("Object to add may not be null");
            }
            if (!set.add(obj)) continue;
            this.fireDataFacetChangeEvent(id, obj, 0);
        }
    }

    public boolean remove(IDT id, T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Object to add may not be null");
        }
        Collection<T> componentSet = this.getCachedSet(id);
        if (componentSet != null && componentSet.remove(obj)) {
            this.fireDataFacetChangeEvent(id, obj, 1);
            if (componentSet.isEmpty()) {
                this.removeCache(id);
            }
            return true;
        }
        return false;
    }

    public void removeAll(IDT id, Collection<T> c) {
        Collection<T> componentSet = this.getCachedSet(id);
        if (componentSet != null) {
            for (T obj : c) {
                if (obj == null) {
                    throw new IllegalArgumentException("Object to add may not be null");
                }
                if (!componentSet.remove(obj)) continue;
                this.fireDataFacetChangeEvent(id, obj, 1);
            }
        }
    }

    public Collection<T> removeAll(IDT id) {
        Collection componentSet = (Collection)this.removeCache(id);
        if (componentSet == null) {
            return Collections.emptySet();
        }
        for (Object obj : componentSet) {
            this.fireDataFacetChangeEvent(id, obj, 1);
        }
        return componentSet;
    }

    public Collection<T> getSet(IDT id) {
        Collection<T> componentSet = this.getCachedSet(id);
        if (componentSet == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableList(new ArrayList<T>(componentSet));
    }

    public int getCount(IDT id) {
        Collection<T> componentSet = this.getCachedSet(id);
        if (componentSet == null) {
            return 0;
        }
        return componentSet.size();
    }

    public boolean isEmpty(IDT id) {
        Collection<T> componentSet = this.getCachedSet(id);
        return componentSet == null || componentSet.isEmpty();
    }

    public boolean contains(IDT id, T obj) {
        Collection<T> componentSet = this.getCachedSet(id);
        return componentSet != null && componentSet.contains(obj);
    }

    protected Collection<T> getCachedSet(IDT id) {
        return (Collection)this.getCache(id);
    }

    private Collection<T> getConstructingCachedSet(IDT id) {
        Collection<T> componentSet = this.getCachedSet(id);
        if (componentSet == null) {
            componentSet = this.getComponentSet();
            this.setCache(id, componentSet);
        }
        return componentSet;
    }

    protected Collection<T> getComponentSet() {
        return new LinkedHashSet();
    }

    @Override
    public void copyContents(IDT source, IDT copy) {
        Collection<T> componentSet = this.getCachedSet(source);
        if (componentSet != null) {
            this.getConstructingCachedSet(copy).addAll(this.getCopyForNewOwner(componentSet));
        }
    }

    protected Collection<T> getCopyForNewOwner(Collection<T> componentSet) {
        return componentSet;
    }

    public boolean replace(IDT id, T old, T replacement) {
        Collection<T> componentSet = this.getCachedSet(id);
        if (componentSet == null || !componentSet.contains(old)) {
            return false;
        }
        Collection<T> replaceSet = this.getComponentSet();
        for (T obj : componentSet) {
            if (obj == old) {
                replaceSet.add(replacement);
                continue;
            }
            replaceSet.add(obj);
        }
        this.setCache(id, componentSet);
        this.fireDataFacetChangeEvent(id, old, 1);
        this.fireDataFacetChangeEvent(id, replacement, 0);
        return true;
    }

    public void addAfter(IDT id, T trigger, T added) {
        Collection<T> componentSet = this.getCachedSet(id);
        if (componentSet != null && componentSet.contains(trigger)) {
            Collection<T> replaceSet = this.getComponentSet();
            for (T obj : componentSet) {
                replaceSet.add(obj);
                if (obj != trigger) continue;
                replaceSet.add(added);
            }
            this.setCache(id, componentSet);
            this.fireDataFacetChangeEvent(id, added, 0);
        }
    }
}

