/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.converter.panel;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import pcgen.gui2.tools.Utility;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class ConversionInputDialog
extends JDialog
implements ActionListener {
    private String introText;
    private String result;
    private JTextField field;

    public ConversionInputDialog(Frame parent, String introText) {
        super(parent, "PCGenDataConvert", true);
        this.introText = introText;
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    public String getResult() {
        return this.result;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JLabel introLabel = new JLabel(this.introText);
        GridBagConstraints gbc = new GridBagConstraints();
        Utility.buildRelativeConstraints(gbc, 0, 1, 1.0, 1.0);
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 5, 10);
        this.add((Component)introLabel, gbc);
        this.field = new JTextField(20);
        Utility.buildRelativeConstraints(gbc, 0, 1, 1.0, 0.0, 2, 17);
        gbc.insets = new Insets(5, 10, 5, 10);
        this.add((Component)this.field, gbc);
        JLabel dummy = new JLabel(" ");
        Utility.buildRelativeConstraints(gbc, 1, 1, 1.0, 0.0, 2, 17);
        this.add((Component)dummy, gbc);
        JButton okButton = new JButton(LanguageBundle.getString("in_ok"));
        okButton.addActionListener(this);
        this.getRootPane().setDefaultButton(okButton);
        Utility.buildRelativeConstraints(gbc, 0, 0, 0.0, 0.0, 0, 13);
        gbc.insets = new Insets(5, 5, 10, 10);
        this.add((Component)okButton, gbc);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConversionInputDialog.this.result = ConversionInputDialog.this.field.getText();
                ConversionInputDialog.this.setVisible(false);
                ConversionInputDialog.this.logInput();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.result = this.field.getText();
        this.setVisible(false);
        this.logInput();
    }

    private void logInput() {
        Logging.log(Logging.INFO, "Decision required: " + this.introText + "\nValue entered: " + this.result);
    }
}

