/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.list.CompanionList;
import pcgen.core.FollowerOption;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.character.Follower;
import pcgen.core.display.CharacterDisplay;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.CompanionFacade;
import pcgen.facade.core.CompanionStubFacade;
import pcgen.facade.core.CompanionSupportFacade;
import pcgen.facade.core.PartyFacade;
import pcgen.facade.core.RaceFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.DefaultMapFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.MapFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.facade.CharacterFacadeImpl;
import pcgen.gui2.facade.CompanionFacadeDelegate;
import pcgen.gui2.facade.CompanionNotLoaded;
import pcgen.gui2.facade.CompanionStub;
import pcgen.gui2.facade.TodoFacadeImpl;
import pcgen.gui2.facade.TodoManager;
import pcgen.system.CharacterManager;
import pcgen.util.Logging;
import pcgen.util.enumeration.Tab;

public class CompanionSupportFacadeImpl
implements CompanionSupportFacade,
ListListener<CharacterFacade> {
    private DefaultListFacade<CompanionFacadeDelegate> companionList;
    private final PlayerCharacter theCharacter;
    private final CharacterDisplay charDisplay;
    private DefaultListFacade<CompanionStubFacade> availCompList;
    private DefaultMapFacade<String, Integer> maxCompanionsMap;
    private Map<String, CompanionList> keyToCompanionListMap;
    private final TodoManager todoManager;
    private final CharacterFacadeImpl pcFacade;

    public CompanionSupportFacadeImpl(PlayerCharacter theCharacter, TodoManager todoManager, ReferenceFacade<String> nameRef, ReferenceFacade<File> fileRef, CharacterFacadeImpl pcFacade) {
        this.theCharacter = theCharacter;
        this.pcFacade = pcFacade;
        this.charDisplay = theCharacter.getDisplay();
        this.todoManager = todoManager;
        this.companionList = new DefaultListFacade();
        this.availCompList = new DefaultListFacade();
        this.maxCompanionsMap = new DefaultMapFacade();
        this.keyToCompanionListMap = new HashMap<String, CompanionList>();
        this.initCompData(true);
        CharacterManager.getCharacters().addListListener(this);
        this.addMasterListeners(nameRef, fileRef);
    }

    private void addMasterListeners(ReferenceFacade<String> nameRef, ReferenceFacade<File> fileRef) {
        nameRef.addReferenceListener(new ReferenceListener<String>(){

            @Override
            public void referenceChanged(ReferenceEvent<String> e) {
                String newName = e.getNewReference();
                for (CompanionFacadeDelegate delegate : CompanionSupportFacadeImpl.this.companionList) {
                    CharacterFacade companion = CharacterManager.getCharacterMatching(delegate);
                    if (companion == null) continue;
                    CharacterFacadeImpl compFacadeImpl = (CharacterFacadeImpl)companion;
                    Follower follower = compFacadeImpl.getTheCharacter().getDisplay().getMaster();
                    follower.setName(newName);
                }
            }
        });
        fileRef.addReferenceListener(new ReferenceListener<File>(){

            @Override
            public void referenceChanged(ReferenceEvent<File> e) {
                File newFile = e.getNewReference();
                for (CompanionFacadeDelegate delegate : CompanionSupportFacadeImpl.this.companionList) {
                    CharacterFacade companion = CharacterManager.getCharacterMatching(delegate);
                    if (companion == null) continue;
                    CharacterFacadeImpl compFacadeImpl = (CharacterFacadeImpl)companion;
                    Follower follower = compFacadeImpl.getTheCharacter().getDisplay().getMaster();
                    follower.setFileName(newFile.getAbsolutePath());
                }
            }
        });
    }

    void refreshCompanionData() {
        this.initCompData(false);
        for (CompanionFacadeDelegate delegate : this.companionList) {
            CompanionFacade compFacade = delegate.getDelegate();
            if (!(compFacade instanceof CharacterFacadeImpl)) continue;
            CharacterFacadeImpl compFacadeImpl = (CharacterFacadeImpl)compFacade;
            PlayerCharacter pc = compFacadeImpl.getTheCharacter();
            pc.setMaster(pc.getDisplay().getMaster());
            compFacadeImpl.refreshClassLevelModel();
            compFacadeImpl.postLevellingUpdates();
        }
    }

    private void initCompData(boolean rebuildCompanionList) {
        ArrayList<CompanionStub> companions = new ArrayList<CompanionStub>();
        for (CompanionList compList : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(CompanionList.class)) {
            this.keyToCompanionListMap.put(compList.getKeyName(), compList);
            Map<FollowerOption, CDOMObject> fMap = this.charDisplay.getAvailableFollowers(compList.getKeyName(), null);
            for (FollowerOption followerOpt : fMap.keySet()) {
                if (followerOpt.getRace() == Globals.s_EMPTYRACE || !followerOpt.qualifies(this.theCharacter, null)) continue;
                companions.add(new CompanionStub(followerOpt.getRace(), compList.getKeyName()));
            }
            int maxVal = this.theCharacter.getMaxFollowers(compList);
            if (maxVal == 0) {
                this.maxCompanionsMap.removeKey(compList.toString());
                continue;
            }
            this.maxCompanionsMap.putValue(compList.toString(), maxVal);
        }
        this.availCompList.updateContents(companions);
        if (rebuildCompanionList) {
            for (Follower follower : this.charDisplay.getFollowerList()) {
                CompanionNotLoaded comp = new CompanionNotLoaded(follower.getName(), new File(follower.getFileName()), follower.getRace(), follower.getType().toString());
                CompanionFacadeDelegate delegate = new CompanionFacadeDelegate();
                delegate.setCompanionFacade(comp);
                this.companionList.addElement(delegate);
            }
        }
        for (CompanionList compList : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(CompanionList.class)) {
            this.updateCompanionTodo(compList.toString());
        }
    }

    private void updateCompanionTodo(String companionType) {
        Integer max = this.maxCompanionsMap.getValue(companionType);
        int maxCompanions = max == null ? 0 : max;
        int numCompanions = 0;
        for (CompanionFacadeDelegate cfd : this.companionList) {
            if (!cfd.getCompanionType().equals(companionType)) continue;
            ++numCompanions;
        }
        if (maxCompanions > -1 && maxCompanions < numCompanions) {
            this.todoManager.addTodo(new TodoFacadeImpl(Tab.COMPANIONS, companionType, "in_companionTodoTooMany", companionType, 1));
            this.todoManager.removeTodo("in_companionTodoRemain", companionType);
        } else if (maxCompanions > -1 && maxCompanions > numCompanions) {
            this.todoManager.addTodo(new TodoFacadeImpl(Tab.COMPANIONS, companionType, "in_companionTodoRemain", companionType, 1));
            this.todoManager.removeTodo("in_companionTodoTooMany", companionType);
        } else {
            this.todoManager.removeTodo("in_companionTodoRemain", companionType);
            this.todoManager.removeTodo("in_companionTodoTooMany", companionType);
        }
    }

    @Override
    public void addCompanion(CharacterFacade companion, String companionType) {
        Race compRace;
        if (companion == null || !(companion instanceof CharacterFacadeImpl)) {
            return;
        }
        CharacterFacadeImpl compFacadeImpl = (CharacterFacadeImpl)companion;
        CompanionList compList = this.keyToCompanionListMap.get(companionType);
        FollowerOption followerOpt = this.getFollowerOpt(compList, compRace = (Race)compFacadeImpl.getRaceRef().getReference());
        if (followerOpt == null) {
            Logging.errorPrint("Unable to find follower option for companion " + companion + " of race " + compRace);
            return;
        }
        if (!followerOpt.qualifies(this.theCharacter, null)) {
            Logging.errorPrint("Not qualified to take companion " + companion + " of race " + compRace);
            return;
        }
        Logging.log(Logging.INFO, "Setting master to " + this.charDisplay.getName() + " for character " + compFacadeImpl);
        Follower newMaster = new Follower(this.charDisplay.getFileName(), this.charDisplay.getName(), compList);
        newMaster.setAdjustment(followerOpt.getAdjustment());
        compFacadeImpl.getTheCharacter().setMaster(newMaster);
        compFacadeImpl.refreshClassLevelModel();
        compFacadeImpl.postLevellingUpdates();
        File compFile = compFacadeImpl.getFileRef().getReference();
        String compFilename = StringUtils.isEmpty(compFile.getPath()) ? "" : compFile.getAbsolutePath();
        Follower follower = new Follower(compFilename, compFacadeImpl.getNameRef().getReference(), compList);
        follower.setRace(compRace);
        this.theCharacter.addFollower(follower);
        this.theCharacter.setCalcFollowerBonus();
        this.theCharacter.calcActiveBonuses();
        this.pcFacade.postLevellingUpdates();
        CompanionFacadeDelegate delegate = new CompanionFacadeDelegate();
        delegate.setCompanionFacade(companion);
        this.companionList.addElement(delegate);
        companion.getFileRef().addReferenceListener(new DelegateFileListener(follower));
        companion.getNameRef().addReferenceListener(new DelegateNameListener(follower));
        this.updateCompanionTodo(companionType);
    }

    private FollowerOption getFollowerOpt(CompanionList compList, Race compRace) {
        FollowerOption followerOpt = null;
        Map<FollowerOption, CDOMObject> fMap = this.charDisplay.getAvailableFollowers(compList.getKeyName(), null);
        for (FollowerOption fOpt : fMap.keySet()) {
            if (compRace != fOpt.getRace()) continue;
            followerOpt = fOpt;
            break;
        }
        return followerOpt;
    }

    @Override
    public void removeCompanion(CompanionFacade companion) {
        if (!(companion instanceof CompanionFacadeDelegate)) {
            return;
        }
        File compFile = companion.getFileRef().getReference();
        for (Follower follower : this.charDisplay.getFollowerList()) {
            File followerFile = new File(follower.getFileName());
            if (!followerFile.equals(compFile)) continue;
            this.theCharacter.delFollower(follower);
            break;
        }
        this.companionList.removeElement((CompanionFacadeDelegate)companion);
        this.updateCompanionTodo(companion.getCompanionType());
    }

    private void linkCompanion(CharacterFacade character) {
        for (CompanionFacadeDelegate delegate : this.companionList) {
            File file = delegate.getFileRef().getReference();
            String name = delegate.getNameRef().getReference();
            RaceFacade race = delegate.getRaceRef().getReference();
            if (!file.equals(character.getFileRef().getReference()) || !name.equals(character.getNameRef().getReference()) || race != null && !race.equals(character.getRaceRef().getReference())) continue;
            String companionType = delegate.getCompanionType();
            delegate.setCompanionFacade(character);
            if (character.getMaster() == null && character.getRaceRef().getReference() != null && !"<none selected>".equals(character.getRaceRef().getReference().getKeyName())) {
                CompanionList compList = this.keyToCompanionListMap.get(companionType);
                Follower newMaster = new Follower(this.charDisplay.getFileName(), this.charDisplay.getName(), compList);
                FollowerOption followerOpt = this.getFollowerOpt(compList, (Race)character.getRaceRef().getReference());
                if (followerOpt != null) {
                    newMaster.setAdjustment(followerOpt.getAdjustment());
                } else {
                    Logging.log(Logging.WARNING, "Failed to find FollowerOption for complist " + compList + " and race " + character.getRaceRef().getReference());
                }
                ((CharacterFacadeImpl)character).getTheCharacter().setMaster(newMaster);
            }
            return;
        }
    }

    void closeCharacter() {
        CharacterManager.getCharacters().removeListListener(this);
    }

    private void unlinkCompanion(CharacterFacade character) {
        for (CompanionFacadeDelegate delegate : this.companionList) {
            File file = delegate.getFileRef().getReference();
            if (!file.equals(character.getFileRef().getReference())) continue;
            CompanionNotLoaded comp = new CompanionNotLoaded(character.getNameRef().getReference(), character.getFileRef().getReference(), character.getRaceRef().getReference(), delegate.getCompanionType());
            delegate.setCompanionFacade(comp);
            return;
        }
    }

    @Override
    public ListFacade<CompanionStubFacade> getAvailableCompanions() {
        return this.availCompList;
    }

    @Override
    public MapFacade<String, Integer> getMaxCompanionsMap() {
        return this.maxCompanionsMap;
    }

    @Override
    public ListFacade<? extends CompanionFacade> getCompanions() {
        return this.companionList;
    }

    @Override
    public void elementAdded(ListEvent<CharacterFacade> e) {
        this.linkCompanion(e.getElement());
    }

    @Override
    public void elementRemoved(ListEvent<CharacterFacade> e) {
        this.unlinkCompanion(e.getElement());
    }

    @Override
    public void elementsChanged(ListEvent<CharacterFacade> e) {
        PartyFacade characters = CharacterManager.getCharacters();
        for (CharacterFacade characterFacade : characters) {
            this.linkCompanion(characterFacade);
        }
    }

    @Override
    public void elementModified(ListEvent<CharacterFacade> e) {
    }

    private class DelegateNameListener
    implements ReferenceListener<String> {
        private final Follower follower;

        public DelegateNameListener(Follower followerIn) {
            this.follower = followerIn;
        }

        @Override
        public void referenceChanged(ReferenceEvent<String> e) {
            this.follower.setName(e.getNewReference());
        }
    }

    private class DelegateFileListener
    implements ReferenceListener<File> {
        private final Follower follower;

        public DelegateFileListener(Follower followerIn) {
            this.follower = followerIn;
        }

        @Override
        public void referenceChanged(ReferenceEvent<File> e) {
            this.follower.setFileName(e.getNewReference().getAbsolutePath());
        }
    }
}

