/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SharedTabPane
extends JTabbedPane {
    private Component sharedComponent = null;

    public SharedTabPane() {
        final SingleSelectionModel selectionModel = this.getModel();
        selectionModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = selectionModel.getSelectedIndex();
                if (index != -1) {
                    SharedTabPane.this.setSharedComponentParent(index);
                }
            }
        });
    }

    public void addTab(String title) {
        this.addTab(title, new JPanel(new BorderLayout()));
    }

    public void addTab(String title, int index) {
        this.insertTab(title, null, new JPanel(new BorderLayout()), null, index);
    }

    public void addTab(Component tabRenderer) {
        int index = this.getTabCount();
        this.addTab(null, new JPanel(new BorderLayout()));
        this.setTabComponentAt(index, tabRenderer);
    }

    public void removeTab(String title) {
        int index = this.indexOfTab(title);
        if (index != -1) {
            this.removeTabAt(index);
        }
    }

    private void setSharedComponentParent(int index) {
        JPanel comp = (JPanel)this.getComponentAt(index);
        comp.add(this.sharedComponent, "Center");
        this.revalidate();
    }

    @Override
    public void removeTabAt(int index) {
        super.removeTabAt(index);
        if (index == this.getSelectedIndex()) {
            this.setSharedComponentParent(index);
            this.fireStateChanged();
        }
    }

    public void setSharedComponent(Component comp) {
        this.sharedComponent = comp;
    }
}

