/*
 * Decompiled with CFR 0.152.
 */
package pcgen.output.publish;

import freemarker.template.TemplateModel;
import java.util.HashMap;
import java.util.Map;
import pcgen.base.util.CaseInsensitiveMap;
import pcgen.base.util.DoubleKeyMap;
import pcgen.cdom.base.ItemFacet;
import pcgen.cdom.base.SetFacet;
import pcgen.cdom.enumeration.CharID;
import pcgen.core.GameMode;
import pcgen.output.base.ModeModelFactory;
import pcgen.output.base.ModelFactory;
import pcgen.output.factory.ItemModelFactory;
import pcgen.output.factory.SetModelFactory;
import pcgen.output.model.BooleanOptionModel;

public final class OutputDB {
    private static DoubleKeyMap<Object, Object, ModelFactory> outModels = new DoubleKeyMap(CaseInsensitiveMap.class, CaseInsensitiveMap.class);
    private static Map<Object, TemplateModel> globalModels = new CaseInsensitiveMap();
    private static Map<Object, ModeModelFactory> modeModels = new CaseInsensitiveMap();

    private OutputDB() {
    }

    public static void registerModelFactory(String name, ModelFactory modelFactory) {
        if (modelFactory == null) {
            throw new IllegalArgumentException("Model Factory may not be null");
        }
        String[] locationElements = name.split("\\.");
        if (locationElements.length == 0) {
            throw new IllegalArgumentException("Name may not be null or empty: " + name);
        }
        if (locationElements.length > 2) {
            throw new IllegalArgumentException("Name may only contain zero or one period");
        }
        String secondName = locationElements.length == 1 ? "" : locationElements[1];
        ModelFactory old = (ModelFactory)outModels.put((Object)locationElements[0], (Object)secondName, (Object)modelFactory);
        if (old != null) {
            throw new UnsupportedOperationException("Cannot have two Output Models using the same name: " + name);
        }
    }

    public static void register(String name, ItemFacet<CharID, ?> facet) {
        OutputDB.registerModelFactory(name, new ItemModelFactory(facet));
    }

    public static void register(String name, SetFacet<CharID, ?> facet) {
        OutputDB.registerModelFactory(name, new SetModelFactory(facet));
    }

    public static Map<String, Object> buildDataModel(CharID id) {
        HashMap<String, Object> input = new HashMap<String, Object>();
        for (Object k1 : outModels.getKeySet()) {
            for (Object k2 : outModels.getSecondaryKeySet(k1)) {
                ModelFactory modelFactory = (ModelFactory)outModels.get(k1, k2);
                Object model = modelFactory.generate(id);
                String k1String = k1.toString();
                if ("".equals(k2.toString())) {
                    input.put(k1String, model);
                    continue;
                }
                OutputDB.ensureMap(input, k1String);
                Map m = (Map)input.get(k1String);
                m.put(k2.toString(), model);
            }
        }
        return input;
    }

    private static void ensureMap(Map<String, Object> input, String k1String) {
        if (!input.containsKey(k1String)) {
            input.put(k1String, new HashMap());
        }
    }

    public static Map<String, Object> buildModeDataModel(GameMode mode) {
        HashMap<String, Object> input = new HashMap<String, Object>();
        for (Object key : modeModels.keySet()) {
            ModeModelFactory modelFactory = modeModels.get(key);
            input.put(key.toString(), modelFactory.generate(mode));
        }
        return input;
    }

    public static void registerMode(String name, ModeModelFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Model Factory may not be null");
        }
        int dotLoc = name.indexOf(46);
        if (dotLoc != -1) {
            throw new IllegalArgumentException("Name may not contain a dot: " + name);
        }
        ModeModelFactory old = modeModels.put(name, factory);
        if (old != null) {
            throw new UnsupportedOperationException("Cannot have two Mode Models using the same name: " + name);
        }
    }

    public static Iterable<?> getIterable(CharID id, String ... keys) {
        String k1 = keys[0];
        String k2 = keys.length > 1 ? keys[1] : "";
        ModelFactory modelFactory = (ModelFactory)outModels.get((Object)k1, (Object)k2);
        if (modelFactory == null) {
            return null;
        }
        return (Iterable)modelFactory.generate(id);
    }

    public static boolean isLegal(String interpolation) {
        return outModels.containsKey((Object)interpolation);
    }

    public static void reset() {
        outModels.clear();
        globalModels.clear();
        modeModels.clear();
    }

    public static Map<Object, TemplateModel> getGlobal() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.putAll(globalModels);
        return map;
    }

    public static void registerBooleanPreference(String pref, boolean defaultValue) {
        if (pref == null || pref.length() == 0) {
            throw new IllegalArgumentException("Preference Name may not be null or empty: " + pref);
        }
        OutputDB.addGlobalModel(pref, (TemplateModel)new BooleanOptionModel(pref, defaultValue));
    }

    public static void addGlobalModel(String name, TemplateModel model) {
        TemplateModel old = globalModels.put(name, model);
        if (old != null) {
            throw new UnsupportedOperationException("Cannot have two Global Output Models using the same name: " + name);
        }
    }
}

