/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.StringTokenizer;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Logging;

public class CasterLevelToken
extends Token {
    public static final String TOKENNAME = "CASTERLEVEL";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        String tag = aTok.nextToken();
        if (!TOKENNAME.equals(tag)) {
            Logging.errorPrint("Invalid CASTERLEVEL token:" + tokenSource, new Throwable());
            return "";
        }
        String varName = "";
        int i = 0;
        if (aTok.hasMoreTokens()) {
            varName = aTok.nextToken();
            try {
                i = Integer.parseInt(varName);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (varName.equals("TOTAL") || varName.equals("")) {
            return Integer.toString(pc.getVariableValue(tokenSource, "TOTAL").intValue());
        }
        return this.getClassToken(pc, i);
    }

    public String getClassToken(PlayerCharacter pc, int classNumber) {
        String cString = "";
        CharacterDisplay display = pc.getDisplay();
        if (display.getClassCount() > classNumber) {
            PCClass pcClass = display.getClassList().get(classNumber);
            cString = "CLASS:" + pcClass.getKeyName();
        }
        return Float.toString(pc.getVariableValue(TOKENNAME, cString).intValue());
    }
}

