/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.Set;
import java.util.TreeSet;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.VariableKey;
import pcgen.core.PCStat;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class DefineLst
implements CDOMPrimaryToken<CDOMObject> {
    public static final Class<PCStat> PCSTAT_CLASS = PCStat.class;

    @Override
    public String getTokenName() {
        return "DEFINE";
    }

    @Override
    public ParseResult parseToken(LoadContext context, CDOMObject obj, String value) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        ParsingSeparator sep = new ParsingSeparator(value, '|');
        if (!sep.hasNext()) {
            return new ParseResult.Fail(this.getTokenName() + " may not be empty", context);
        }
        String firstItem = sep.next();
        if (firstItem.startsWith("UNLOCK.")) {
            return new ParseResult.Fail("DEFINE:UNLOCK. has been deprecated, please use DEFINESTAT:STAT| or DEFINESTAT:UNLOCK|", context);
        }
        if (!sep.hasNext()) {
            return new ParseResult.Fail(this.getTokenName() + " varName|varFormula" + "or LOCK.<stat>|value syntax requires an argument", context);
        }
        String var = firstItem;
        if (var.length() == 0) {
            return new ParseResult.Fail("Empty Variable Name found in " + this.getTokenName() + ": " + value, context);
        }
        try {
            Formula f = FormulaFactory.getFormulaFor(sep.next());
            if (!f.isValid()) {
                return new ParseResult.Fail("Formula in " + this.getTokenName() + " was not valid: " + f.toString(), context);
            }
            if (!(f.isStatic() && f.resolveStatic().intValue() == 0 || var.startsWith("MAXLEVELSTAT="))) {
                Logging.deprecationPrint("DEFINE with a non zero value has been deprecated, please use a DEFINE of 0 and an appropriate bonus. Tag was DEFINE:" + value + " in " + obj, context);
            }
            if (sep.hasNext()) {
                return new ParseResult.Fail(this.getTokenName() + " " + firstItem + " syntax requires only one argument: " + value, context);
            }
            if (value.startsWith("LOCK.")) {
                return new ParseResult.Fail("DEFINE:LOCK. has been deprecated, please use DEFINESTAT:LOCL| or DEFINESTAT:NONSTAT|", context);
            }
            context.getObjectContext().put(obj, VariableKey.getConstant(var), f);
            return ParseResult.SUCCESS;
        }
        catch (IllegalArgumentException e) {
            return new ParseResult.Fail("Illegal Formula found in " + this.getTokenName() + ": " + value + " " + e.getLocalizedMessage(), context);
        }
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        Set<VariableKey> keys = context.getObjectContext().getVariableKeys(obj);
        TreeSet<String> set = new TreeSet<String>();
        if (keys != null && !keys.isEmpty()) {
            for (VariableKey key : keys) {
                set.add(key.toString() + "|" + context.getObjectContext().getVariable(obj, key));
            }
        }
        if (set.isEmpty()) {
            return null;
        }
        return set.toArray(new String[set.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

