/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.gamemode.basedice;

import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.content.BaseDice;
import pcgen.core.RollInfo;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class UpToken
extends AbstractTokenWithSeparator<BaseDice>
implements CDOMPrimaryToken<BaseDice> {
    @Override
    public String getTokenName() {
        return "UP";
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, BaseDice bd, String value) {
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            String roll = st.nextToken();
            try {
                bd.addToUpList(new RollInfo(roll));
            }
            catch (IllegalArgumentException e) {
                return new ParseResult.Fail("Invalid Roll provided: " + roll + " in " + value, context);
            }
        }
        return ParseResult.SUCCESS;
    }

    @Override
    protected char separator() {
        return ',';
    }

    @Override
    public String[] unparse(LoadContext context, BaseDice bd) {
        return new String[]{StringUtil.join(bd.getUpSteps(), (String)",")};
    }

    @Override
    public Class<BaseDice> getTokenClass() {
        return BaseDice.class;
    }
}

