/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class BonusspellstatToken
extends AbstractNonEmptyToken<PCClass>
implements CDOMPrimaryToken<PCClass> {
    private static final Class<PCStat> PCSTAT_CLASS = PCStat.class;

    @Override
    public String getTokenName() {
        return "BONUSSPELLSTAT";
    }

    @Override
    public ParseResult parseNonEmptyToken(LoadContext context, PCClass pcc, String value) {
        if ("NONE".equals(value)) {
            context.getObjectContext().put((CDOMObject)pcc, ObjectKey.HAS_BONUS_SPELL_STAT, Boolean.FALSE);
            return ParseResult.SUCCESS;
        }
        context.getObjectContext().put((CDOMObject)pcc, ObjectKey.HAS_BONUS_SPELL_STAT, Boolean.TRUE);
        CDOMSingleRef<PCStat> pcs = context.getReferenceContext().getCDOMReference(PCSTAT_CLASS, value);
        if (pcs == null) {
            return new ParseResult.Fail("Invalid Stat Abbreviation in " + this.getTokenName() + ": " + value, context);
        }
        context.getObjectContext().put((CDOMObject)pcc, ObjectKey.BONUS_SPELL_STAT, pcs);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, PCClass pcc) {
        Boolean bss = context.getObjectContext().getObject(pcc, ObjectKey.HAS_BONUS_SPELL_STAT);
        CDOMSingleRef<PCStat> pcs = context.getObjectContext().getObject(pcc, ObjectKey.BONUS_SPELL_STAT);
        if (bss == null) {
            if (pcs != null) {
                context.addWriteMessage(this.getTokenName() + " expected HAS_BONUS_SPELL_STAT to exist " + "if BONUS_SPELL_STAT was defined");
            }
            return null;
        }
        if (bss.booleanValue()) {
            if (pcs == null) {
                context.addWriteMessage(this.getTokenName() + " expected BONUS_SPELL_STAT to exist " + "since HAS_BONUS_SPELL_STAT was false");
                return null;
            }
            return new String[]{pcs.getLSTformat(false)};
        }
        return new String[]{"NONE"};
    }

    @Override
    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

