/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass.level;

import pcgen.base.formula.AddingFormula;
import pcgen.base.formula.DividingFormula;
import pcgen.base.formula.MultiplyingFormula;
import pcgen.base.formula.ReferenceFormula;
import pcgen.base.formula.SubtractingFormula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.HitDie;
import pcgen.cdom.content.Processor;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.processor.HitDieFormula;
import pcgen.cdom.processor.HitDieLock;
import pcgen.cdom.processor.HitDieStep;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;

public class HitdieLst
extends AbstractToken
implements CDOMPrimaryToken<PCClassLevel> {
    public String getTokenName() {
        return "HITDIE";
    }

    public ParseResult parseToken(LoadContext context, PCClassLevel level, String value) {
        try {
            HitDieFormula hdm;
            String lock = value;
            int pipeLoc = lock.indexOf("|");
            if (pipeLoc != -1) {
                return new ParseResult.Fail(this.getTokenName() + " is invalid has a pipe: " + value, context);
            }
            if (lock.startsWith("%/")) {
                int denom = Integer.parseInt(lock.substring(2));
                if (denom <= 0) {
                    return new ParseResult.Fail(this.getTokenName() + " was expecting a Positive Integer " + "for dividing Lock, was : " + lock.substring(2), context);
                }
                hdm = new HitDieFormula((ReferenceFormula)new DividingFormula(denom));
            } else if (lock.startsWith("%*")) {
                int mult = Integer.parseInt(lock.substring(2));
                if (mult <= 0) {
                    return new ParseResult.Fail(this.getTokenName() + " was expecting a Positive " + "Integer for multiplying Lock, was : " + lock.substring(2), context);
                }
                hdm = new HitDieFormula((ReferenceFormula)new MultiplyingFormula(mult));
            } else if (lock.startsWith("%+")) {
                int add = Integer.parseInt(lock.substring(2));
                if (add <= 0) {
                    return new ParseResult.Fail(this.getTokenName() + " was expecting a Positive " + "Integer for adding Lock, was : " + lock.substring(2), context);
                }
                hdm = new HitDieFormula((ReferenceFormula)new AddingFormula(add));
            } else if (lock.startsWith("%-")) {
                int sub = Integer.parseInt(lock.substring(2));
                if (sub <= 0) {
                    return new ParseResult.Fail(this.getTokenName() + " was expecting a Positive " + "Integer for subtracting Lock, was : " + lock.substring(2), context);
                }
                hdm = new HitDieFormula((ReferenceFormula)new SubtractingFormula(sub));
            } else if (lock.startsWith("%up")) {
                int steps = Integer.parseInt(lock.substring(3));
                if (steps <= 0) {
                    return new ParseResult.Fail("Invalid Step Count: " + steps + " in " + this.getTokenName() + " up (must be positive)", context);
                }
                if (steps >= 5) {
                    return new ParseResult.Fail("Invalid Step Count: " + steps + " in " + this.getTokenName() + " up (too large)", context);
                }
                hdm = new HitDieStep(steps, new HitDie(12));
            } else if (lock.startsWith("%Hup")) {
                int steps = Integer.parseInt(lock.substring(4));
                if (steps <= 0) {
                    return new ParseResult.Fail("Invalid Step Count: " + steps + " in " + this.getTokenName(), context);
                }
                hdm = new HitDieStep(steps, null);
            } else if (lock.startsWith("%down")) {
                int steps = Integer.parseInt(lock.substring(5));
                if (steps <= 0) {
                    return new ParseResult.Fail("Invalid Step Count: " + steps + " in " + this.getTokenName() + " down (must be positive)", context);
                }
                if (steps >= 5) {
                    return new ParseResult.Fail("Invalid Step Count: " + steps + " in " + this.getTokenName() + " down (too large)", context);
                }
                hdm = new HitDieStep(-steps, new HitDie(4));
            } else if (lock.startsWith("%Hdown")) {
                int steps = Integer.parseInt(lock.substring(6));
                if (steps <= 0) {
                    return new ParseResult.Fail("Invalid Step Count: " + steps + " in " + this.getTokenName(), context);
                }
                hdm = new HitDieStep(-steps, null);
            } else {
                int i = Integer.parseInt(lock);
                if (i <= 0) {
                    return new ParseResult.Fail("Invalid HitDie: " + i + " in " + this.getTokenName(), context);
                }
                hdm = new HitDieLock(new HitDie(i));
            }
            context.getObjectContext().put((CDOMObject)level, ObjectKey.HITDIE, (Object)hdm);
            return ParseResult.SUCCESS;
        }
        catch (NumberFormatException nfe) {
            ComplexParseResult pr = new ComplexParseResult();
            pr.addErrorMessage("Invalid Number in " + this.getTokenName() + ": " + nfe.getLocalizedMessage());
            pr.addErrorMessage("  Must be an Integer");
            return pr;
        }
    }

    public String[] unparse(LoadContext context, PCClassLevel level) {
        Processor hdcf = (Processor)context.getObjectContext().getObject((CDOMObject)level, ObjectKey.HITDIE);
        if (hdcf == null) {
            return null;
        }
        return new String[]{hdcf.getLSTformat()};
    }

    public Class<PCClassLevel> getTokenClass() {
        return PCClassLevel.class;
    }
}

