/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class SpellstatToken
extends AbstractNonEmptyToken<PCClass>
implements CDOMPrimaryToken<PCClass> {
    private static final Class<PCStat> PCSTAT_CLASS = PCStat.class;

    public String getTokenName() {
        return "SPELLSTAT";
    }

    public ParseResult parseNonEmptyToken(LoadContext context, PCClass pcc, String value) {
        if ("SPELL".equalsIgnoreCase(value)) {
            context.getObjectContext().put((CDOMObject)pcc, ObjectKey.USE_SPELL_SPELL_STAT, (Object)Boolean.TRUE);
            return ParseResult.SUCCESS;
        }
        context.getObjectContext().put((CDOMObject)pcc, ObjectKey.USE_SPELL_SPELL_STAT, (Object)Boolean.FALSE);
        if ("OTHER".equalsIgnoreCase(value)) {
            context.getObjectContext().put((CDOMObject)pcc, ObjectKey.CASTER_WITHOUT_SPELL_STAT, (Object)Boolean.TRUE);
            return ParseResult.SUCCESS;
        }
        context.getObjectContext().put((CDOMObject)pcc, ObjectKey.CASTER_WITHOUT_SPELL_STAT, (Object)Boolean.FALSE);
        CDOMSingleRef pcs = context.getReferenceContext().getCDOMReference(PCSTAT_CLASS, value);
        if (pcs == null) {
            return new ParseResult.Fail("Invalid Stat Abbreviation in " + this.getTokenName() + ": " + value, context);
        }
        context.getObjectContext().put((CDOMObject)pcc, ObjectKey.SPELL_STAT, (Object)pcs);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCClass pcc) {
        CDOMSingleRef pcs = (CDOMSingleRef)context.getObjectContext().getObject((CDOMObject)pcc, ObjectKey.SPELL_STAT);
        Boolean useStat = (Boolean)context.getObjectContext().getObject((CDOMObject)pcc, ObjectKey.USE_SPELL_SPELL_STAT);
        Boolean otherCaster = (Boolean)context.getObjectContext().getObject((CDOMObject)pcc, ObjectKey.CASTER_WITHOUT_SPELL_STAT);
        if (useStat == null) {
            if (pcs != null) {
                context.addWriteMessage(this.getTokenName() + " expected USE_SPELL_SPELL_STAT to exist " + "if SPELL_STAT was defined");
            }
            if (otherCaster != null) {
                context.addWriteMessage(this.getTokenName() + " expected USE_SPELL_SPELL_STAT to exist " + "if CASTER_WITHOUT_SPELL_STAT was defined");
            }
            return null;
        }
        if (useStat.booleanValue()) {
            return new String[]{"SPELL"};
        }
        if (otherCaster == null) {
            context.addWriteMessage(this.getTokenName() + " expected CASTER_WITHOUT_SPELL_STAT to exist " + "if USE_SPELL_SPELL_STAT was false");
            return null;
        }
        if (otherCaster.booleanValue()) {
            return new String[]{"OTHER"};
        }
        if (pcs == null) {
            context.addWriteMessage(this.getTokenName() + " expected SPELL_STAT to exist since USE_SPELL_SPELL_STAT " + "and CASTER_WITHOUT_SPELL_STAT were false");
            return null;
        }
        return new String[]{pcs.getLSTformat(false)};
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

