/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.core.Equipment;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class AltcritmultToken
extends AbstractNonEmptyToken<Equipment>
implements CDOMPrimaryToken<Equipment> {
    public String getTokenName() {
        return "ALTCRITMULT";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, Equipment eq, String value) {
        Integer cm;
        block6: {
            cm = null;
            if (value.length() > 0 && value.charAt(0) == 'x') {
                try {
                    cm = Integer.valueOf(value.substring(1));
                    if (cm <= 0) {
                        return new ParseResult.Fail(this.getTokenName() + " cannot be <= 0", context);
                    }
                    break block6;
                }
                catch (NumberFormatException nfe) {
                    return new ParseResult.Fail(this.getTokenName() + " was expecting an Integer: " + value, context);
                }
            }
            if ("-".equals(value)) {
                cm = -1;
            }
        }
        if (cm == null) {
            return new ParseResult.Fail(this.getTokenName() + " was expecting x followed by an integer " + "or the special value '-' (representing no value)", context);
        }
        EquipmentHead altHead = eq.getEquipmentHead(2);
        context.getObjectContext().put((CDOMObject)altHead, IntegerKey.CRIT_MULT, cm);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Equipment eq) {
        String retString;
        EquipmentHead head = eq.getEquipmentHeadReference(2);
        if (head == null) {
            return null;
        }
        Integer mult = context.getObjectContext().getInteger((CDOMObject)head, IntegerKey.CRIT_MULT);
        if (mult == null) {
            return null;
        }
        int multInt = mult;
        if (multInt == -1) {
            retString = "-";
        } else {
            if (multInt <= 0) {
                context.addWriteMessage(this.getTokenName() + " cannot be <= 0");
                return null;
            }
            retString = "x" + multInt;
        }
        return new String[]{retString};
    }

    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

