/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.stream.output;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import uk.org.webcompere.systemstubs.stream.output.OutputFactory;

public interface Output<T extends OutputStream> {
    public static <S extends OutputStream> Output<S> fromStream(S stream) {
        return () -> stream;
    }

    public static <S extends OutputStream> Output<S> fromCloseableStream(final S stream) {
        return new Output<S>(){

            @Override
            public void closeOutput() throws Exception {
                stream.close();
            }

            @Override
            public S getOutputStream() {
                return stream;
            }
        };
    }

    default public String getText() {
        return "";
    }

    default public void clear() {
    }

    default public void closeOutput() throws Exception {
    }

    public T getOutputStream();

    default public Output<T> getOutput() {
        return this;
    }

    default public Stream<String> getLines() {
        return Arrays.stream(this.getText().split(Pattern.quote(System.lineSeparator())));
    }

    default public String getLinesNormalized() {
        return this.getLinesNormalized("\n");
    }

    default public String getLinesNormalized(String linebreak) {
        String combined = this.getLines().collect(Collectors.joining(linebreak));
        if (combined.isEmpty()) {
            return "";
        }
        return combined + linebreak;
    }

    default public OutputFactory<T> factoryOfSelf() {
        return original -> this;
    }
}

