/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.buildinit.plugins.internal.BuildContentGenerationContext;
import org.gradle.buildinit.plugins.internal.BuildContentGenerator;
import org.gradle.buildinit.plugins.internal.BuildInitializer;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.LanguageSpecificAdaptor;
import org.gradle.buildinit.plugins.internal.ProjectGenerator;
import org.gradle.buildinit.plugins.internal.SimpleGlobalFilesBuildSettingsDescriptor;
import org.gradle.buildinit.plugins.internal.VersionCatalogDependencyRegistry;
import org.gradle.buildinit.plugins.internal.VersionCatalogGenerator;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;

public class CompositeProjectInitDescriptor
implements BuildInitializer {
    private final ProjectGenerator descriptor;
    private final List<? extends BuildContentGenerator> generators;

    public CompositeProjectInitDescriptor(ProjectGenerator projectGenerator, List<? extends BuildContentGenerator> generators) {
        this.generators = generators;
        this.descriptor = projectGenerator;
    }

    @Override
    public String getId() {
        return this.descriptor.getId();
    }

    @Override
    public ComponentType getComponentType() {
        return this.descriptor.getComponentType();
    }

    @Override
    public Language getLanguage() {
        return this.descriptor.getLanguage();
    }

    @Override
    public boolean supportsJavaTargets() {
        return this.descriptor.isJvmLanguage();
    }

    @Override
    public Set<ModularizationOption> getModularizationOptions() {
        return this.descriptor.getModularizationOptions();
    }

    @Override
    public boolean supportsProjectName() {
        return true;
    }

    @Override
    public boolean supportsPackage() {
        return this.descriptor.supportsPackage();
    }

    @Override
    public BuildInitDsl getDefaultDsl() {
        return this.descriptor.getDefaultDsl();
    }

    @Override
    public Set<BuildInitDsl> getDsls() {
        return new TreeSet<BuildInitDsl>(Arrays.asList(BuildInitDsl.values()));
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return this.descriptor.getDefaultTestFramework();
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return this.descriptor.getTestFrameworks();
    }

    @Override
    public Optional<String> getFurtherReading(InitSettings settings) {
        return this.descriptor.getFurtherReading(settings);
    }

    @Override
    public void generate(InitSettings settings) {
        BuildContentGenerationContext buildContentGenerationContext = new BuildContentGenerationContext(new VersionCatalogDependencyRegistry(false));
        for (BuildContentGenerator buildContentGenerator : this.generators) {
            buildContentGenerator.generate(settings, buildContentGenerationContext);
        }
        this.descriptor.generate(settings, buildContentGenerationContext);
        VersionCatalogGenerator.create(settings.getTarget()).generate(buildContentGenerationContext);
    }

    public Map<String, List<String>> generateWithExternalComments(InitSettings settings) {
        BuildContentGenerationContext buildContentGenerationContext = new BuildContentGenerationContext(new VersionCatalogDependencyRegistry(false));
        if (!(this.descriptor instanceof LanguageSpecificAdaptor)) {
            throw new UnsupportedOperationException();
        }
        for (BuildContentGenerator buildContentGenerator : this.generators) {
            if (buildContentGenerator instanceof SimpleGlobalFilesBuildSettingsDescriptor) {
                ((SimpleGlobalFilesBuildSettingsDescriptor)buildContentGenerator).generateWithoutComments(settings, buildContentGenerationContext);
                continue;
            }
            buildContentGenerator.generate(settings, buildContentGenerationContext);
        }
        Map<String, List<String>> comments = ((LanguageSpecificAdaptor)this.descriptor).generateWithExternalComments(settings, buildContentGenerationContext);
        VersionCatalogGenerator.create(settings.getTarget()).generate(buildContentGenerationContext);
        return comments;
    }
}

