/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Project;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.internal.FeatureSpecInternal;
import org.gradle.api.plugins.jvm.internal.DefaultJvmFeature;
import org.gradle.api.plugins.jvm.internal.JvmFeatureInternal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;

public class DefaultJavaFeatureSpec
implements FeatureSpecInternal {
    private final String name;
    private final List<Capability> capabilities = new ArrayList<Capability>(1);
    private final ProjectInternal project;
    private SourceSet sourceSet;
    private boolean withJavadocJar = false;
    private boolean withSourcesJar = false;
    private boolean allowPublication = true;

    public DefaultJavaFeatureSpec(String name, ProjectInternal project) {
        this.name = name;
        this.project = project;
    }

    public void usingSourceSet(SourceSet sourceSet) {
        this.sourceSet = sourceSet;
    }

    public void capability(String group, String name, String version) {
        this.capabilities.add((Capability)new DefaultImmutableCapability(group, name, version));
    }

    public void withJavadocJar() {
        this.withJavadocJar = true;
    }

    public void withSourcesJar() {
        this.withSourcesJar = true;
    }

    public void disablePublication() {
        this.allowPublication = false;
    }

    @Override
    public boolean isPublished() {
        return this.allowPublication;
    }

    @Override
    public JvmFeatureInternal create() {
        if (this.sourceSet == null) {
            throw new InvalidUserCodeException("You must specify which source set to use for feature '" + this.name + "'");
        }
        if (this.capabilities.isEmpty()) {
            this.capabilities.add((Capability)new ProjectDerivedCapability((Project)this.project, this.name));
        }
        DefaultJvmFeature feature = new DefaultJvmFeature(this.name, this.sourceSet, this.capabilities, this.project, true, SourceSet.isMain((SourceSet)this.sourceSet));
        feature.withApi();
        if (this.withJavadocJar) {
            feature.withJavadocJar();
        }
        if (this.withSourcesJar) {
            feature.withSourcesJar();
        }
        return feature;
    }
}

