/* ex :tabstop=4 noet: */

#include <stdarg.h>
#include <stddef.h>
#ifdef WIN32
	#include "types.h"
#else
	#include <stdint.h> /* uint32_t and friends */
#endif
#include <sys/types.h> /* u_char and friends */

#define MIN(a, b)	((a) < (b) ? a : b)
#define MAX(a, b)	((a) > (b) ? a : b)

#define LOG2 (0.693147180559945)

size_t bytes_dump_hex_line(const u_char *bytes, size_t offset, size_t len);
void bytes_dump_hex(const u_char *bytes, size_t offset, size_t len);
uint32_t pow_2_up(uint32_t);

void endian_init(void);
int machine_is_big_endian(void);
int machine_is_little_endian(void);

char * strup(char *);
char * strdown(char *str);
char * strtrim(char *);

int xstrcmp(const char *, const char *);
int xstrncmp(const char *, const char *, size_t);
int vstrcmp(const void *, const void *);
int vxstrcmp(const void *, const void *);

char * xstrdup(const char *);
void * vxstrdup(void *);

/* OpenBSD's excellent, sane, string functions */
size_t strlcpy(char *, const char *, size_t);
size_t strlcat(char *, const char *, size_t);

char * xstrcpy(char *, const char *);

void bytes_dump_escape(const void *bytes, size_t len);
#define BYTES_DUMP_ESCAPE_BUFLEN(len)	(((len) * 4) + 1)
char * bytes_dump_escape_buf(char *dest, size_t destlen, const void *bytes, size_t len);
char * bytes_dump_hex_buf(char *dest, size_t destlen, const void *bytes, size_t len);

/* TODO: move these to facts.c perhaps? */
int unsigned hash_func_DJB(const void *);
int unsigned hash_func_ip(const void *);
int unsigned hash_func_mac(const void *);
int unsigned hash_func_int(const void *);

/* Microsoft is brain-damaged */
#if defined(WIN32) || defined(TIGER)
	int snprintf(char *, size_t, const char *, ...);
#endif
#if defined(WIN32) || defined(TIGER)
	int vsnprintf(char *, size_t, const char *, va_list);
#endif

