/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.ProblemLocation;
import org.gradle.api.problems.internal.DefaultProblem;
import org.gradle.api.problems.internal.DefaultProblemLocation;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;

@Nonnull
public class ValidationProblemSerialization {
    public static List<DefaultProblem> parseMessageList(String lines) {
        GsonBuilder gsonBuilder = ValidationProblemSerialization.createGsonBuilder();
        Gson gson = gsonBuilder.create();
        Type type = new TypeToken<List<DefaultProblem>>(){}.getType();
        return (List)gson.fromJson(lines, type);
    }

    public static GsonBuilder createGsonBuilder() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(DocLink.class, (Object)new DocLinkAdapter());
        gsonBuilder.registerTypeHierarchyAdapter(ProblemLocation.class, (Object)new ProblemLocationAdapter());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ThrowableAdapterFactory());
        return gsonBuilder;
    }

    public static Stream<String> toPlainMessage(List<DefaultProblem> problems) {
        return problems.stream().map(problem -> problem.getSeverity() + ": " + TypeValidationProblemRenderer.renderMinimalInformationAbout((Problem)problem));
    }

    public static class DocLinkAdapter
    extends TypeAdapter<DocLink> {
        public void write(JsonWriter out, @Nullable DocLink value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("url").value(value.getUrl());
            out.name("consultDocumentationMessage").value(value.getConsultDocumentationMessage());
            out.endObject();
        }

        public DocLink read(JsonReader in) throws IOException {
            in.beginObject();
            String url = null;
            String consultDocumentationMessage = null;
            block8: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "url": {
                        url = in.nextString();
                        continue block8;
                    }
                    case "consultDocumentationMessage": {
                        consultDocumentationMessage = in.nextString();
                        continue block8;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            final String finalUrl = url;
            final String finalConsultDocumentationMessage = consultDocumentationMessage;
            return new DocLink(){

                public String getUrl() {
                    return finalUrl;
                }

                public String getConsultDocumentationMessage() {
                    return finalConsultDocumentationMessage;
                }
            };
        }
    }

    public static class ProblemLocationAdapter
    extends TypeAdapter<ProblemLocation> {
        public void write(JsonWriter out, @Nullable ProblemLocation value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("path").value(value.getPath());
            out.name("line").value((Number)value.getLine());
            out.name("column").value((Number)value.getColumn());
            out.endObject();
        }

        public ProblemLocation read(JsonReader in) throws IOException {
            in.beginObject();
            String path = null;
            Integer line = null;
            Integer column = null;
            block10: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "path": {
                        path = in.nextString();
                        continue block10;
                    }
                    case "line": {
                        line = in.nextInt();
                        continue block10;
                    }
                    case "column": {
                        column = in.nextInt();
                        continue block10;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            Objects.requireNonNull(path, "path must not be null");
            return new DefaultProblemLocation(path, line, column);
        }
    }

    public static class ThrowableTypeAdapter
    extends TypeAdapter<Throwable> {
        private final TypeToken<Throwable> typeToken;

        public ThrowableTypeAdapter(TypeToken<Throwable> typeToken) {
            this.typeToken = typeToken;
        }

        @Nullable
        public Throwable read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            String message = null;
            Throwable cause = null;
            block11: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "message": {
                        message = in.nextString();
                        continue block11;
                    }
                    case "cause": {
                        cause = this.read(in);
                        continue block11;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            try {
                Constructor constructor;
                if (message == null && cause == null) {
                    constructor = this.typeToken.getRawType().getDeclaredConstructor(new Class[0]);
                    return (Throwable)constructor.newInstance(new Object[0]);
                }
                if (message == null) {
                    constructor = this.typeToken.getRawType().getDeclaredConstructor(Throwable.class);
                    return (Throwable)constructor.newInstance(cause);
                }
                if (cause == null) {
                    constructor = this.typeToken.getRawType().getDeclaredConstructor(String.class);
                    return (Throwable)constructor.newInstance(message);
                }
                constructor = this.typeToken.getRawType().getDeclaredConstructor(String.class, Throwable.class);
                return (Throwable)constructor.newInstance(message, cause);
            }
            catch (NoSuchMethodException e) {
                if (message == null && cause == null) {
                    return new RuntimeException();
                }
                if (message == null) {
                    return new RuntimeException(cause);
                }
                if (cause == null) {
                    return new RuntimeException(message);
                }
                return new RuntimeException(message, cause);
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }

        public void write(JsonWriter out, @Nullable Throwable throwable) throws IOException {
            if (throwable == null) {
                out.nullValue();
            } else if (throwable.getMessage() == null && throwable.getCause() != null) {
                this.write(out, throwable.getCause());
            } else {
                out.beginObject();
                if (throwable.getMessage() != null) {
                    out.name("message");
                    out.value(throwable.getMessage());
                }
                if (ThrowableTypeAdapter.shouldWriteCause(throwable)) {
                    out.name("cause");
                    this.write(out, throwable.getCause());
                }
                out.endObject();
            }
        }

        private static boolean shouldWriteCause(Throwable throwable) {
            Throwable cause = throwable.getCause();
            if (cause == null || cause.getMessage() == null || cause == throwable) {
                return false;
            }
            return throwable.getMessage() == null || !throwable.getMessage().contains(cause.getMessage());
        }
    }

    public static class ThrowableAdapterFactory
    implements TypeAdapterFactory {
        @Nullable
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!Throwable.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return new ThrowableTypeAdapter(typeToken);
        }
    }
}

