/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.impl.lcdui;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.microedition.midlet.ApplicationManager;
import org.me4se.impl.lcdui.PhysicalFont;

public class AwtFont
extends PhysicalFont {
    public Font font;
    FontMetrics metrics;
    String name = "Arial";
    boolean bold;
    boolean italic;
    boolean underlined;
    boolean overprint;

    AwtFont(int height, boolean bold, boolean italic, boolean underlined) {
        this.height = height;
        this.bold = bold;
        this.italic = italic;
        this.underlined = underlined;
        this.init();
    }

    AwtFont(String desc) {
        if (desc != null) {
            int cut0 = desc.indexOf(45);
            int cut1 = desc.indexOf(45, cut0 + 1);
            this.name = desc.substring(0, cut0);
            String style = desc.substring(cut0 + 1, cut1).trim().toLowerCase();
            this.height = Integer.parseInt(desc.substring(cut1 + 1).trim());
            this.bold = style.indexOf("bold") != -1;
            this.italic = style.indexOf("italic") != -1;
        }
        this.init();
    }

    public void init() {
        int flags = (this.bold ? 1 : 0) + (this.italic ? 2 : 0);
        this.height = (int)((double)this.height * ApplicationManager.getDisplayDensity());
        int points = this.height * 3;
        this.font = new Font(this.name, flags, points);
        this.metrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        points = points * this.height / (this.metrics.getAscent() + this.metrics.getDescent());
        this.font = new Font(this.name, flags, points);
        this.metrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        this.ascent = this.metrics.getAscent();
        this.descent = this.metrics.getDescent();
        this.leading = this.height - this.ascent - this.descent;
    }

    public void drawString(Graphics g, String s, int x, int y) {
        g.setFont(this.font);
        g.drawString(s, x, y);
        if (this.underlined) {
            g.drawLine(x, y + 1, x + this.stringWidth(s), y + 1);
        }
    }

    public int stringWidth(String s) {
        return this.metrics.stringWidth(s);
    }

    public int charWidth(char c) {
        return this.metrics.charWidth(c);
    }

    public int charsWidth(char[] c, int start, int len) {
        return this.metrics.charsWidth(c, start, len);
    }
}

