/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.psi.java1.media.audio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.ToneControl;
import javax.microedition.midlet.ApplicationManager;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import org.me4se.impl.BasicMMDataSource;
import org.me4se.impl.BasicMMPlayer;

public class MidiPlayerImpl
extends BasicMMPlayer
implements ToneControl,
MetaEventListener {
    static Object lock = new Object();
    static MidiPlayerImpl activeMidiPlayer;
    static Sequencer sequencer;
    int level = 100;
    private Sequence sequence;
    static byte[] MIDI_HEADER;

    public MidiPlayerImpl() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDuration() {
        Object object = lock;
        synchronized (object) {
            return this.sequence == null ? -1L : this.sequence.getMicrosecondLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMediaTime() {
        Object object = lock;
        synchronized (object) {
            return this.state == 400 ? sequencer.getMicrosecondPosition() : Math.max(0L, this.desiredTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prefetchImpl() throws MidiUnavailableException, InvalidMidiDataException, IOException, InterruptedException {
        Object object = lock;
        synchronized (object) {
            if (sequencer == null) {
                sequencer = MidiSystem.getSequencer();
                sequencer.addMetaEventListener(this);
                if (!sequencer.isOpen()) {
                    sequencer.open();
                }
            }
            this.sequence = MidiSystem.getSequence("audio/x-tone-seq".equalsIgnoreCase(this.dataSource.getContentType()) ? this.convertToneSequence(this.dataSource.getData()) : this.dataSource.getInputStream());
            this.duration = this.sequence.getMicrosecondLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startImpl() throws InvalidMidiDataException, MediaException {
        Object object = lock;
        synchronized (object) {
            if (activeMidiPlayer == this) {
                return;
            }
            if (activeMidiPlayer != null) {
                throw new MediaException("Too many midi/tone players");
            }
            activeMidiPlayer = this;
            sequencer.setSequence(this.sequence);
            if (this.desiredTime != -1L) {
                sequencer.setMicrosecondPosition(this.desiredTime);
                this.desiredTime = -1L;
            } else if (sequencer.getMicrosecondPosition() >= sequencer.getMicrosecondLength()) {
                sequencer.setMicrosecondPosition(0L);
            }
            sequencer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopImpl() throws MediaException {
        Object object = lock;
        synchronized (object) {
            if (activeMidiPlayer == this) {
                sequencer.stop();
                activeMidiPlayer = null;
            }
        }
    }

    public Control getControl(String s) {
        if (this.state == 100) {
            throw new IllegalStateException();
        }
        return s.endsWith("ToneControl") ? this : super.getControl(s);
    }

    private void writeTime(OutputStream os, int time, int overflow) throws IOException {
        if (time > 127) {
            this.writeTime(os, time >> 7, 128);
        }
        os.write(time & 0x7F | overflow);
    }

    private void writeNote(OutputStream os, int pause, int note, int duration, int volume) throws IOException {
        this.writeTime(os, pause, 0);
        os.write(144);
        os.write(note);
        os.write(volume);
        this.writeTime(os, duration, 0);
        os.write(128);
        os.write(note);
        os.write(0);
    }

    public void setSequence(byte[] toneSequence) {
        if (toneSequence[0] != -2 || toneSequence[1] != 1) {
            throw new IllegalArgumentException();
        }
        if (this.state == 300 || this.state == 400) {
            throw new IllegalStateException();
        }
        this.dataSource = new BasicMMDataSource("device://tone");
        this.dataSource.setData(toneSequence);
        this.dataSource.setContentType("audio/x-tone-seq");
    }

    public InputStream convertToneSequence(byte[] toneSequence) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int pos = 2;
            baos.write(0);
            baos.write(192);
            baos.write(81);
            int[] blocks = new int[127];
            int resolution = 64;
            int volume = 127;
            int bpm = 120;
            if (toneSequence[pos] == -3) {
                bpm = toneSequence[++pos] * 4;
                ++pos;
            }
            if (toneSequence[pos] == -4) {
                resolution = toneSequence[++pos];
                ++pos;
            }
            baos.write(0);
            baos.write(255);
            baos.write(81);
            baos.write(3);
            int tempo = 60000000 / bpm;
            baos.write(tempo >>> 16 & 0xFF);
            baos.write(tempo >>> 8 & 0xFF);
            baos.write(tempo & 0xFF);
            while (pos < toneSequence.length && toneSequence[pos] == -5) {
                byte cmd;
                byte blockId = toneSequence[pos + 1];
                blocks[blockId] = pos + 2;
                pos += 2;
                while ((cmd = toneSequence[pos++]) != -6) {
                    if (cmd >= 0 || cmd == -1 || cmd == -9 || cmd == -8) {
                        ++pos;
                        continue;
                    }
                    System.out.println("Unsupported tone sequence command: " + cmd);
                }
                if (toneSequence[pos] != blockId) {
                    throw new RuntimeException("Block termination issue!");
                }
                ++pos;
            }
            StringBuffer stack = new StringBuffer();
            byte repeat = 1;
            int pause = 0;
            block11: while (pos < toneSequence.length) {
                byte cmd;
                if ((cmd = toneSequence[pos++]) > 0) {
                    int duration = toneSequence[pos++] * repeat;
                    this.writeNote(baos, pause * 4, cmd, duration * 4, volume);
                    pause = 0;
                    repeat = 1;
                    continue;
                }
                switch (cmd) {
                    case -8: {
                        volume = toneSequence[pos++] * 100 / 127;
                        continue block11;
                    }
                    case -9: {
                        repeat = toneSequence[pos++];
                        continue block11;
                    }
                    case -1: {
                        pause += toneSequence[pos++] * repeat;
                        repeat = 1;
                        continue block11;
                    }
                    case -7: {
                        stack.append((char)(pos + 1));
                        pos = blocks[toneSequence[pos]];
                        continue block11;
                    }
                    case -6: {
                        pos = stack.charAt(stack.length() - 1);
                        stack.deleteCharAt(stack.length() - 1);
                        continue block11;
                    }
                }
                System.out.println("Unrecognized Tone Sequence command: " + cmd);
            }
            baos.write(0);
            baos.write(255);
            baos.write(47);
            baos.write(0);
            baos.close();
            byte[] track = baos.toByteArray();
            baos = new ByteArrayOutputStream();
            int len = track.length;
            baos.write(MIDI_HEADER);
            baos.write(resolution);
            baos.write(77);
            baos.write(84);
            baos.write(114);
            baos.write(107);
            baos.write(len >>> 24 & 0xFF);
            baos.write(len >>> 16 & 0xFF);
            baos.write(len >>> 8 & 0xFF);
            baos.write(len & 0xFF);
            baos.write(track);
            baos.close();
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void meta(MetaMessage meta) {
        if (meta.getType() == 47) {
            Object object = lock;
            synchronized (object) {
                if (activeMidiPlayer != null && MidiPlayerImpl.activeMidiPlayer.state == 400 && sequencer.getMicrosecondPosition() >= sequencer.getMicrosecondLength() - 10000L) {
                    if (MidiPlayerImpl.activeMidiPlayer.loopCount != 1) {
                        activeMidiPlayer.notifyListeners("endOfMedia", null);
                        sequencer.setMicrosecondPosition(0L);
                        sequencer.start();
                        if (MidiPlayerImpl.activeMidiPlayer.loopCount != -1) {
                            --MidiPlayerImpl.activeMidiPlayer.loopCount;
                        }
                    } else {
                        ApplicationManager.getInstance().activePlayers.removeElement(activeMidiPlayer);
                        MidiPlayerImpl.activeMidiPlayer.state = 200;
                        activeMidiPlayer.notifyListeners("stopped", null);
                        activeMidiPlayer = null;
                    }
                }
            }
        }
    }

    static {
        MIDI_HEADER = new byte[]{77, 84, 104, 100, 0, 0, 0, 6, 0, 0, 0, 1, 0};
    }
}

