/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.guishared;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;
import javax.swing.JPanel;
import net.yura.domination.engine.RiskUtil;

public class ErdeAnsicht
extends JPanel
implements ImageProducer {
    double xs = 5.0;
    double xp = 0.0;
    double q = 1.0;
    double phi = 0.0;
    double phigrad = 0.0;
    double psi = 0.0;
    double psigrad = 0.0;
    double cosphi = 1.0;
    double sinphi = 0.0;
    double cospsi = 1.0;
    double sinpsi = 0.0;
    double alpha = 0.0;
    boolean zeichnetex = true;
    boolean wireframe = false;
    boolean showinfo = false;
    Image puffer;
    Graphics pufferg;
    double[][][] KugelNetz = new double[36][19][3];
    double[][][] RotKugelNetz = new double[36][19][3];
    double[][] punkte = new double[3000][3];
    Color[] farbe = new Color[1500];
    int anzlinie = 0;
    int[] text;
    int textwidth = 0;
    int textheight = 0;
    double[][] mark = new double[4][3];
    boolean ismark = false;
    int addmxy = 0;
    int dux = 0;
    int duy = 0;
    int dvx = 0;
    int dvy = 0;
    int dudvdet = 0;
    double mdux = 0.0;
    double mduy = 0.0;
    double mdvx = 0.0;
    double mdvy = 0.0;
    private ImageConsumer consumer;
    private DirectColorModel directCM = new DirectColorModel(24, 0xFF0000, 65280, 255);
    int textsize;
    int[] texttmp;
    int texttmpgr;
    int texttmpsize;
    int weiss = Color.BLACK.getRGB();
    Image textproj = this.createImage(this);

    public ErdeAnsicht() {
        for (int b = 0; b <= 18; ++b) {
            double ps = this.toradians(b * 10);
            double cosps = Math.cos(ps);
            double sinps = Math.sin(ps);
            for (int l = 0; l < 36; ++l) {
                double ph = this.toradians(l * 10);
                double cosph = Math.cos(ph);
                double sinph = Math.sin(ph);
                this.KugelNetz[l][b][0] = sinps * cosph;
                this.KugelNetz[l][b][1] = sinps * sinph;
                this.KugelNetz[l][b][2] = cosps;
            }
        }
    }

    public void init() {
        this.setviewp(this.xs, this.q);
        this.setrot(this.phigrad, this.psigrad);
        this.puffer = this.createImage(this.getSize().width, this.getSize().height);
        this.pufferg = this.puffer.getGraphics();
        this.zeichnen();
    }

    public void setviewp(double setXs, double setQ) {
        this.q = setQ;
        this.xs = setXs;
        double a = 1.0 / Math.sqrt(this.xs * this.xs - 1.0);
        double b = a * this.xs;
        double max = this.getSize().height;
        if (this.puffer != null) {
            max = this.puffer.getHeight(this);
        }
        this.xp = (this.q * max - 2.0 * b) / (2.0 * a);
        this.alpha = 1.0 / (this.xs * this.xs - 1.0);
    }

    public void setmark(double l, double b, boolean setze) {
        double[] p1 = new double[]{-1.0, 0.05, 0.05};
        double[] p2 = new double[]{-1.0, -0.05, -0.05};
        double[] p3 = new double[]{-1.0, -0.05, 0.05};
        double[] p4 = new double[]{-1.0, 0.05, -0.05};
        this.ismark = setze;
        p1 = this.rotonepoint(p1, 0.0, l);
        p1 = this.rotonepoint(p1, b, 0.0);
        p2 = this.rotonepoint(p2, 0.0, l);
        p2 = this.rotonepoint(p2, b, 0.0);
        p3 = this.rotonepoint(p3, 0.0, l);
        p3 = this.rotonepoint(p3, b, 0.0);
        p4 = this.rotonepoint(p4, 0.0, l);
        p4 = this.rotonepoint(p4, b, 0.0);
        for (int i = 0; i < 3; ++i) {
            this.mark[0][i] = p1[i];
            this.mark[1][i] = p2[i];
            this.mark[2][i] = p3[i];
            this.mark[3][i] = p4[i];
        }
    }

    public double[] rotonepoint(double[] P, double rotphi, double rotpsi) {
        double radrotphi = this.toradians(rotphi);
        double radrotpsi = this.toradians(rotpsi);
        double cosrotphi = Math.cos(radrotphi);
        double sinrotphi = Math.sin(radrotphi);
        double cosrotpsi = Math.cos(radrotpsi);
        double sinrotpsi = Math.sin(radrotpsi);
        double[] V = new double[]{cosrotpsi * cosrotphi * P[0] - cosrotpsi * sinrotphi * P[1] - sinrotpsi * P[2], sinrotphi * P[0] + cosrotphi * P[1], sinrotpsi * cosrotphi * P[0] - sinrotpsi * sinrotphi * P[1] + cosrotpsi * P[2]};
        return V;
    }

    public void rotpoints(double rotphi, double rotpsi) {
        double radrotphi = this.toradians(rotphi);
        double radrotpsi = this.toradians(rotpsi);
        double cosrotphi = Math.cos(radrotphi);
        double sinrotphi = Math.sin(radrotphi);
        double cosrotpsi = Math.cos(radrotpsi);
        double sinrotpsi = Math.sin(radrotpsi);
        for (int i = 0; i < this.anzlinie * 2 + 1; ++i) {
            double[] V = new double[]{cosrotpsi * cosrotphi * this.punkte[i][0] - cosrotpsi * sinrotphi * this.punkte[i][1] - sinrotpsi * this.punkte[i][2], sinrotphi * this.punkte[i][0] + cosrotphi * this.punkte[i][1], sinrotpsi * cosrotphi * this.punkte[i][0] - sinrotpsi * sinrotphi * this.punkte[i][1] + cosrotpsi * this.punkte[i][2]};
            this.punkte[i] = V;
        }
    }

    public double toradians(double w) {
        return w * Math.PI / 180.0;
    }

    public void setrot(double setphi, double setpsi) {
        if ((setphi %= 360.0) < -180.0) {
            setphi += 360.0;
        }
        if (setphi > 180.0) {
            setphi -= 360.0;
        }
        if (setpsi > 90.0) {
            setpsi = 90.0;
        }
        if (setpsi < -90.0) {
            setpsi = -90.0;
        }
        this.phigrad = setphi;
        this.psigrad = setpsi;
        this.phi = this.toradians(setphi);
        this.psi = this.toradians(setpsi);
        this.cosphi = Math.cos(this.phi);
        this.sinphi = Math.sin(this.phi);
        this.cospsi = Math.cos(this.psi);
        this.sinpsi = Math.sin(this.psi);
    }

    public double[] rot(double[] V) {
        double[] Vrot = new double[]{this.cospsi * this.cosphi * V[0] - this.cospsi * this.sinphi * V[1] - this.sinpsi * V[2], this.sinphi * V[0] + this.cosphi * V[1], this.sinpsi * this.cosphi * V[0] - this.sinpsi * this.sinphi * V[1] + this.cospsi * V[2]};
        return Vrot;
    }

    public void rotkugel() {
        for (int l = 0; l < 36; ++l) {
            for (int b = 0; b <= 18; ++b) {
                this.RotKugelNetz[l][b] = this.rot(this.KugelNetz[l][b]);
            }
        }
    }

    public int[] proj(double[] V) {
        int[] projvect = new int[]{(int)(V[1] * (this.xs + this.xp) / (V[0] + this.xs)), -((int)(V[2] * (this.xs + this.xp) / (V[0] + this.xs)))};
        return projvect;
    }

    public void setline(double[] V1, double[] V2, Color C) {
        for (int i = 0; i < 3; ++i) {
            this.punkte[this.anzlinie * 2][i] = V1[i];
            this.punkte[this.anzlinie * 2 + 1][i] = V2[i];
        }
        this.farbe[this.anzlinie] = C;
        ++this.anzlinie;
    }

    public void zeichneline(double[] V1, double[] V2, Color C) {
        int[] P1 = this.proj(V1);
        int[] P2 = this.proj(V2);
        int transl = this.puffer.getHeight(this) / 2;
        this.pufferg.setColor(C);
        this.pufferg.drawLine(P1[0] + transl, P1[1] + transl, P2[0] + transl, P2[1] + transl);
        this.pufferg.drawLine(P2[0] + transl, P2[1] + transl, P1[0] + transl, P1[1] + transl);
    }

    public boolean inkegel(double[] V) {
        return V[1] * V[1] + V[2] * V[2] < this.alpha * (V[0] + this.xs) * (V[0] + this.xs);
    }

    public void line3d(double[] V1, double[] V2, Color C) {
        double[] Vrot1 = this.rot(V1);
        double[] Vrot2 = this.rot(V2);
        if (Vrot1[0] < 0.0 && Vrot2[0] < 0.0) {
            this.zeichneline(Vrot1, Vrot2, C);
        } else if (this.inkegel(Vrot1) && Vrot1[0] < 0.0) {
            this.zeichneline(Vrot1, Vrot2, C);
        } else if (this.inkegel(Vrot2) && Vrot2[0] < 0.0) {
            this.zeichneline(Vrot1, Vrot2, C);
        } else {
            double[] a = Vrot1;
            double[] dArray = new double[]{Vrot2[0] - Vrot1[0], Vrot2[1] - Vrot1[1], Vrot2[2] - Vrot1[2]};
            double[] r = dArray;
            double bgl = 2.0 * a[1] * r[1] + 2.0 * a[2] * r[2] - 2.0 * this.alpha * r[0] * a[0] - 2.0 * this.alpha * this.xs * r[0];
            double agl = r[1] * r[1] + r[2] * r[2] - this.alpha * r[0] * r[0];
            double cgl = a[1] * a[1] + a[2] * a[2] - this.alpha * a[0] * a[0] - 2.0 * this.alpha * this.xs * a[0] - this.alpha * this.xs * this.xs;
            double diskr = bgl * bgl - 4.0 * agl * cgl;
            if (diskr <= 0.0) {
                this.zeichneline(Vrot1, Vrot2, C);
            } else {
                double t1 = (-bgl - Math.sqrt(diskr)) / (2.0 * agl);
                double[] Ps1 = new double[]{a[0] + t1 * r[0], a[1] + t1 * r[1], a[2] + t1 * r[2]};
                double t2 = (-bgl + Math.sqrt(diskr)) / (2.0 * agl);
                double[] Ps2 = new double[]{a[0] + t2 * r[0], a[1] + t2 * r[1], a[2] + t2 * r[2]};
                if (t1 > 0.0 && t1 < 1.0) {
                    this.zeichneline(Vrot1, Ps1, C);
                }
                if (t2 > 0.0 && t2 < 1.0) {
                    this.zeichneline(Vrot2, Ps2, C);
                }
                if (!(!(t1 < 0.0) && !(t1 > 1.0) || !(t2 < 0.0) && !(t2 > 1.0) || this.inkegel(Vrot1) && this.inkegel(Vrot2))) {
                    this.zeichneline(Vrot1, Vrot2, C);
                }
            }
        }
    }

    public void line3dkugel(double[] V1, double[] V2, Color C) {
        if (V1[0] < 0.0 && V2[0] < 0.0) {
            this.zeichneline(V1, V2, C);
        }
    }

    public void addConsumer(ImageConsumer imageconsumer) {
    }

    public boolean isConsumer(ImageConsumer imageconsumer) {
        return false;
    }

    public void removeConsumer(ImageConsumer imageconsumer) {
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageconsumer) {
    }

    public void startProduction(ImageConsumer imageconsumer) {
        int texttmpgr = (int)((double)this.puffer.getHeight(this) * this.q) + 4;
        this.consumer = imageconsumer;
        this.consumer.setDimensions(texttmpgr, texttmpgr);
        this.consumer.setColorModel(this.directCM);
        this.consumer.setHints(2);
    }

    public void settext(Image img) {
        this.textheight = img.getHeight(this);
        this.textwidth = img.getWidth(this);
        this.textsize = this.textheight * this.textwidth;
        this.text = new int[this.textsize];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, this.textwidth, this.textheight, this.text, 0, this.textwidth);
        try {
            pg.grabPixels();
        }
        catch (Exception e) {
            RiskUtil.printStackTrace(e);
        }
        this.prepareImage(this.textproj, null);
    }

    public int[] mappoint(int l, int b) {
        int[] p = new int[]{this.textwidth - l * this.textwidth / 36, b * this.textheight / 18};
        return p;
    }

    public void gettext() {
        if (this.text != null) {
            this.texttmpgr = (int)((double)this.puffer.getHeight(this) * this.q) + 4;
            this.texttmpsize = this.texttmpgr * this.texttmpgr;
            this.texttmp = new int[this.texttmpsize];
            for (int i = 0; i < this.texttmpsize; ++i) {
                this.texttmp[i] = this.weiss;
            }
            for (int l = 0; l < 36; ++l) {
                for (int b = 0; b < 18; ++b) {
                    this.deform(l, b, l + 1, b, l + 1, b + 1);
                    this.deform(l, b, l, b + 1, l + 1, b + 1);
                }
            }
            int transl = (this.puffer.getHeight(this) - this.texttmpgr) / 2 - 2;
            if (this.consumer != null) {
                this.consumer.setPixels(0, 0, this.texttmpgr, this.texttmpgr, (ColorModel)this.directCM, this.texttmp, 0, this.texttmpgr);
                this.consumer.imageComplete(2);
            }
            this.pufferg.drawImage(this.textproj, transl, transl, this);
        }
    }

    public void deform(int l1, int b1, int l2, int b2, int l3, int b3) {
        double[] V1 = this.RotKugelNetz[l1 % 36][b1];
        double[] V2 = this.RotKugelNetz[l2 % 36][b2];
        double[] V3 = this.RotKugelNetz[l3 % 36][b3];
        if (V1[0] < 0.0 && V2[0] < 0.0 && V3[0] < 0.0) {
            int[] P1 = this.proj(V1);
            int[] P2 = this.proj(V2);
            int[] P3 = this.proj(V3);
            int[] map0 = this.mappoint(l1, b1);
            int[] map1 = this.mappoint(l2, b2);
            int[] map2 = this.mappoint(l3, b3);
            int[] mapx = new int[]{map0[0], map1[0], map2[0]};
            int[] mapy = new int[]{map0[1], map1[1], map2[1]};
            int[] sx = new int[]{P1[0], P2[0], P3[0]};
            int[] sy = new int[]{P1[1], P2[1], P3[1]};
            this.draw3eck(mapx, mapy, sx, sy);
        }
    }

    public void scanline(int y, int xa, int xb, int[] mapx, int[] mapy, int[] scrx, int[] scry) {
        int px = 0;
        int py = y - scry[0];
        int xstart = 0;
        int xend = 0;
        boolean tmapx = false;
        boolean tmapy = false;
        int tmpoffset = (y + this.addmxy) * this.texttmpgr + this.addmxy;
        if (xa <= xb) {
            xstart = xa;
            xend = xb;
        } else {
            xstart = xb;
            xend = xa;
        }
        px = xstart - scrx[0];
        double ustart = (double)(this.dvx * py) / (double)this.dudvdet;
        double vstart = (double)(this.dux * py) / (double)this.dudvdet;
        double uschritt = (double)this.dvy / (double)this.dudvdet;
        double vschritt = (double)this.duy / (double)this.dudvdet;
        double u = (double)px * uschritt - ustart;
        double v = vstart - (double)px * vschritt;
        double tmapxr = (double)mapx[0] + u * this.mdux + v * this.mdvx;
        double tmapyr = (double)mapy[0] + u * this.mduy + v * this.mdvy;
        double ux = uschritt * this.mdux;
        double uy = uschritt * this.mduy;
        double vx = vschritt * this.mdvx;
        double vy = vschritt * this.mdvy;
        double uxvx = ux - vx;
        double uyvy = uy - vy;
        int i = 0;
        int j = tmpoffset + xstart;
        for (int mx = xstart; mx <= xend; ++mx) {
            i = (int)(tmapyr += uyvy) * this.textwidth + (int)(tmapxr += uxvx);
            if (i >= 0 && i < this.textsize && j >= 0 && j < this.texttmpsize) {
                this.texttmp[j] = this.text[i];
            }
            ++j;
        }
    }

    public void draw3eck(int[] mapx, int[] mapy, int[] scrx, int[] scry) {
        int tmp;
        if (scry[0] > scry[1]) {
            tmp = scry[1];
            scry[1] = scry[0];
            scry[0] = tmp;
            tmp = scrx[1];
            scrx[1] = scrx[0];
            scrx[0] = tmp;
            tmp = mapy[1];
            mapy[1] = mapy[0];
            mapy[0] = tmp;
            tmp = mapx[1];
            mapx[1] = mapx[0];
            mapx[0] = tmp;
        }
        if (scry[0] > scry[2]) {
            tmp = scry[0];
            scry[0] = scry[2];
            scry[2] = tmp;
            tmp = scrx[0];
            scrx[0] = scrx[2];
            scrx[2] = tmp;
            tmp = mapy[0];
            mapy[0] = mapy[2];
            mapy[2] = tmp;
            tmp = mapx[0];
            mapx[0] = mapx[2];
            mapx[2] = tmp;
        }
        if (scry[1] > scry[2]) {
            tmp = scry[1];
            scry[1] = scry[2];
            scry[2] = tmp;
            tmp = scrx[1];
            scrx[1] = scrx[2];
            scrx[2] = tmp;
            tmp = mapy[1];
            mapy[1] = mapy[2];
            mapy[2] = tmp;
            tmp = mapx[1];
            mapx[1] = mapx[2];
            mapx[2] = tmp;
        }
        this.dux = scrx[1] - scrx[0];
        this.duy = scry[1] - scry[0];
        this.dvx = scrx[2] - scrx[0];
        this.dvy = scry[2] - scry[0];
        this.dudvdet = this.dux * this.dvy - this.duy * this.dvx;
        if (this.dudvdet != 0) {
            int y;
            double xa;
            this.addmxy = this.texttmpgr / 2 + 2;
            double delta01 = 0.0;
            double delta02 = 0.0;
            double delta12 = 0.0;
            this.mdux = mapx[1] - mapx[0];
            this.mduy = mapy[1] - mapy[0];
            this.mdvx = mapx[2] - mapx[0];
            this.mdvy = mapy[2] - mapy[0];
            double xb = xa = (double)scrx[0];
            if (scry[0] - scry[1] != 0) {
                delta01 = (double)this.dux / (double)this.duy;
            } else {
                xa = scrx[1];
            }
            if (scry[0] - scry[2] != 0) {
                delta02 = (double)this.dvx / (double)this.dvy;
            }
            if (scry[1] - scry[2] != 0) {
                delta12 = (double)(scrx[1] - scrx[2]) / (double)(scry[1] - scry[2]);
            }
            for (y = scry[0]; y < scry[1]; ++y) {
                this.scanline(y, (int)xa, (int)xb, mapx, mapy, scrx, scry);
                xa += delta01;
                xb += delta02;
            }
            for (y = scry[1]; y <= scry[2]; ++y) {
                this.scanline(y, (int)xa, (int)xb, mapx, mapy, scrx, scry);
                xa += delta12;
                xb += delta02;
            }
        }
    }

    public void box() {
        double[] p1 = new double[]{-1.0, -1.0, -1.0};
        double[] p2 = new double[]{-1.0, 1.0, -1.0};
        double[] p3 = new double[]{-1.0, 1.0, 1.0};
        double[] p4 = new double[]{-1.0, -1.0, 1.0};
        double[] p5 = new double[]{1.0, -1.0, -1.0};
        double[] p6 = new double[]{1.0, 1.0, -1.0};
        double[] p7 = new double[]{1.0, 1.0, 1.0};
        double[] p8 = new double[]{1.0, -1.0, 1.0};
        this.setline(p1, p2, Color.black);
        this.setline(p2, p3, Color.black);
        this.setline(p3, p4, Color.black);
        this.setline(p4, p1, Color.black);
        this.setline(p5, p6, Color.black);
        this.setline(p6, p7, Color.black);
        this.setline(p7, p8, Color.black);
        this.setline(p8, p5, Color.black);
        this.setline(p1, p5, Color.black);
        this.setline(p2, p6, Color.black);
        this.setline(p3, p7, Color.black);
        this.setline(p4, p8, Color.black);
    }

    public void kords() {
        double[] p1 = new double[]{1.0, 0.0, 0.0};
        double[] p2 = new double[]{5.0, 0.0, 0.0};
        this.setline(p1, p2, Color.black);
        double[] p3 = new double[]{-1.0, 0.0, 0.0};
        double[] p4 = new double[]{-5.0, 0.0, 0.0};
        this.setline(p3, p4, Color.black);
        double[] p5 = new double[]{0.0, 1.0, 0.0};
        double[] p6 = new double[]{0.0, 5.0, 0.0};
        this.setline(p5, p6, Color.black);
        double[] p7 = new double[]{0.0, -1.0, 0.0};
        double[] p8 = new double[]{0.0, -5.0, 0.0};
        this.setline(p7, p8, Color.black);
        double[] p9 = new double[]{0.0, 0.0, 1.0};
        double[] p10 = new double[]{0.0, 0.0, 5.0};
        this.setline(p9, p10, Color.black);
        double[] p11 = new double[]{0.0, 0.0, -1.0};
        double[] p12 = new double[]{0.0, 0.0, -5.0};
        this.setline(p11, p12, Color.black);
    }

    public void kegel() {
        double sinwi;
        double coswi;
        double wi;
        this.punkte = new double[3000][3];
        this.farbe = new Color[1500];
        this.anzlinie = 0;
        double[] p2 = new double[]{0.0, 0.0, Math.sqrt(2.0)};
        for (int i = 0; i < 36; ++i) {
            wi = this.toradians(i * 10);
            coswi = Math.cos(wi);
            sinwi = Math.sin(wi);
            double[] p1 = new double[]{coswi * Math.sqrt(2.0), sinwi * Math.sqrt(2.0), 0.0};
            this.setline(p1, p2, Color.black);
        }
        for (int j = 0; j < 36; ++j) {
            wi = this.toradians(j * 10);
            coswi = Math.cos(wi) * Math.sqrt(2.0);
            sinwi = Math.sin(wi) * Math.sqrt(2.0);
            double wi2 = this.toradians((j + 1) * 10 % 360);
            double coswi2 = Math.cos(wi2) * Math.sqrt(2.0);
            double sinwi2 = Math.sin(wi2) * Math.sqrt(2.0);
            double[] oben1 = new double[]{coswi, sinwi, 0.0};
            double[] oben2 = new double[]{coswi2, sinwi2, 0.0};
            this.setline(oben1, oben2, Color.black);
        }
    }

    public void zylinder() {
        double sinwi;
        double coswi;
        double wi;
        this.punkte = new double[3000][3];
        this.farbe = new Color[1500];
        this.anzlinie = 0;
        for (int i = 0; i < 36; ++i) {
            wi = this.toradians(i * 10);
            coswi = Math.cos(wi);
            sinwi = Math.sin(wi);
            double[] p1 = new double[]{coswi, sinwi, -1.0};
            double[] p2 = new double[]{coswi, sinwi, 1.0};
            this.setline(p1, p2, Color.black);
        }
        for (int j = 0; j < 36; ++j) {
            wi = this.toradians(j * 10);
            coswi = Math.cos(wi);
            sinwi = Math.sin(wi);
            double wi2 = this.toradians((j + 1) * 10 % 360);
            double coswi2 = Math.cos(wi2);
            double sinwi2 = Math.sin(wi2);
            double[] oben1 = new double[]{coswi, sinwi, 1.0};
            double[] oben2 = new double[]{coswi2, sinwi2, 1.0};
            this.setline(oben1, oben2, Color.black);
            double[] unten1 = new double[]{coswi, sinwi, -1.0};
            double[] unten2 = new double[]{coswi2, sinwi2, -1.0};
            this.setline(unten1, unten2, Color.black);
        }
    }

    public void tangent(double z) {
        this.punkte = new double[3000][3];
        this.farbe = new Color[1500];
        this.anzlinie = 0;
        for (double i = -1.0; i <= 1.0; i += 0.1) {
            double[] p1 = new double[]{i, 1.0, z};
            double[] p2 = new double[]{i, -1.0, z};
            double[] p3 = new double[]{1.0, i, z};
            double[] p4 = new double[]{-1.0, i, z};
            this.setline(p1, p2, Color.black);
            this.setline(p3, p4, Color.black);
        }
    }

    public void kugel() {
        for (int b = 0; b <= 18; ++b) {
            for (int l = 0; l < 36; ++l) {
                this.line3dkugel(this.RotKugelNetz[l][b], this.RotKugelNetz[(l + 1) % 36][b], b == 9 ? Color.red : Color.lightGray);
            }
        }
        for (int l = 0; l < 36; ++l) {
            for (int b = 0; b < 18; ++b) {
                this.line3dkugel(this.RotKugelNetz[l][b], this.RotKugelNetz[l][b + 1], l == 0 || l == 18 ? Color.red : Color.lightGray);
            }
        }
    }

    public void zeichnen() {
        if (this.puffer != null) {
            this.rotkugel();
            if (this.zeichnetex) {
                this.gettext();
            }
            if (this.wireframe) {
                this.kugel();
            }
            for (int i = 0; i < this.anzlinie; ++i) {
                this.line3d(this.punkte[i * 2], this.punkte[i * 2 + 1], this.farbe[i]);
            }
            if (this.ismark) {
                this.line3d(this.mark[0], this.mark[1], Color.red);
                this.line3d(this.mark[2], this.mark[3], Color.red);
            }
            if (this.showinfo) {
                this.pufferg.setColor(Color.WHITE);
                this.pufferg.drawString("Longitude: " + Double.toString(Math.abs(this.phigrad)) + (this.phigrad >= 0.0 ? "E" : "W"), 10, 20);
                this.pufferg.drawString("Latitude: " + Double.toString(Math.abs(this.psigrad)) + (this.psigrad >= 0.0 ? "N" : "S"), 10, 35);
            }
            this.paintComponent(this.getGraphics());
        }
    }

    public void paintComponent(Graphics g) {
        if (this.puffer != null) {
            g.drawImage(this.puffer, 0, 0, this);
        }
    }

    public void rotate(double a, double b) {
        this.setrot(this.phigrad + a, this.psigrad + b);
        this.zeichnen();
    }

    public void toggleWireframe() {
        this.wireframe = !this.wireframe;
        this.zeichnen();
    }

    public void toggleInfo() {
        this.showinfo = !this.showinfo;
        this.zeichnen();
    }
}

