/*
 * Decompiled with CFR 0.152.
 */
package net.yura.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.Timer;
import net.yura.swing.GraphicsUtil;

public class SpriteIcon
implements Icon {
    Image image;
    int width;
    int height;
    int delay = 100;
    private WeakHashMap<Component, WeakReference<Timer>> timers = new WeakHashMap();

    public SpriteIcon(URL img, int rows, int cols) {
        this(SpriteIcon.readfully(img), rows, cols);
    }

    private static Image readfully(URL url) {
        try {
            return ImageIO.read(url);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public SpriteIcon(Image img, int rows, int cols) {
        this.image = img;
        this.width = this.image.getWidth(null) / cols;
        this.height = this.image.getHeight(null) / rows;
    }

    public int getIconWidth() {
        return GraphicsUtil.scale(this.width);
    }

    public int getIconHeight() {
        return GraphicsUtil.scale(this.height);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        int cols = this.image.getWidth(null) / this.width;
        int rows = this.image.getHeight(null) / this.height;
        int totalFrames = cols * rows;
        long time = System.currentTimeMillis();
        int frame = (int)(time % (long)(totalFrames * this.delay)) / this.delay;
        int drawX = frame % cols * this.width;
        int drawY = frame / cols * this.height;
        g.drawImage(this.image, x, y, x + this.getIconWidth(), y + this.getIconHeight(), drawX, drawY, drawX + this.width, drawY + this.height, c);
        this.delayedRepaint(c);
    }

    private void delayedRepaint(final Component component) {
        Timer timer;
        WeakReference<Timer> maybeTimer = this.timers.get(component);
        Timer timer2 = timer = maybeTimer == null ? null : (Timer)maybeTimer.get();
        if (timer == null) {
            timer = new Timer(this.delay, null);
            timer.setRepeats(false);
            timer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    component.repaint();
                }
            });
            this.timers.put(component, new WeakReference<Timer>(timer));
        }
        if (!timer.isRunning()) {
            timer.restart();
        }
    }
}

