/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.util.Vector;
import net.yura.mobile.gui.ChangeListener;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.components.Label;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.Option;

public class Spinner
extends Label {
    private Icon leftSelectedIcon;
    private Icon leftUnselectedIcon;
    private Icon rightSelectedIcon;
    private Icon rightUnselectedIcon;
    private boolean leftPress = false;
    private boolean rightPress = false;
    private ChangeListener chl;
    private Vector list;
    private boolean continuous = false;
    private int index = 0;
    private int max = Integer.MAX_VALUE;
    private int min = Integer.MIN_VALUE;

    public Spinner() {
        this(null, false);
    }

    public Spinner(Vector vec, boolean cont) {
        super((String)null);
        this.focusable = true;
        this.setHorizontalAlignment(1);
        this.continuous = cont;
        if (vec != null) {
            this.setList(vec);
        } else {
            super.setValue(new Integer(this.index));
        }
    }

    public void addChangeListener(ChangeListener l) {
        if (this.chl != null) {
            Logger.warn("trying to add a ChangeListener when there is already one registered");
            Logger.dumpStack();
        }
        if (l == null) {
            Logger.warn("trying to add a null ChangeListener");
            Logger.dumpStack();
        }
        this.chl = l;
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.chl == l) {
            this.chl = null;
        } else {
            Logger.warn("trying to remove a ChangeListener that is not registered");
            Logger.dumpStack();
        }
        if (l == null) {
            Logger.warn("trying to remove a null ChangeListener");
            Logger.dumpStack();
        }
    }

    public void processMouseEvent(int type, int x, int y, KeyEvent keys) {
        super.processMouseEvent(type, x, y, keys);
        if (!this.focusable) {
            return;
        }
        if (type == 1) {
            int offset = 0;
            offset = (this.getWidthWithBorder() - this.getWidth()) / 2;
            if (x < 0 && x > -offset) {
                this.leftPress = true;
            } else if (x > this.width && x < this.width + offset) {
                this.rightPress = true;
            }
            this.fire();
        } else if (type == 2) {
            if (this.leftPress || this.rightPress) {
                this.leftPress = false;
                this.rightPress = false;
                this.repaint();
            }
        } else if (type == 3) {
            Object newVal = null;
            if (this.leftPress) {
                this.leftPress = false;
                newVal = this.getNextValue();
            } else if (this.rightPress) {
                this.rightPress = false;
                newVal = this.getPreviousValue();
            }
            if (newVal != null) {
                this.setValue(newVal);
            }
            this.repaint();
        }
    }

    protected void workoutMinimumSize() {
        if (this.list != null && !this.list.isEmpty()) {
            DesktopPane dp;
            int maxWidth = 0;
            int maxHeight = 0;
            for (int i = 0; i < this.list.size(); ++i) {
                int hi;
                Object obj = this.list.elementAt(i);
                Icon img = obj instanceof Option ? ((Option)obj).getIcon() : null;
                int len = this.getCombinedWidth(String.valueOf(obj), img != null ? img.getIconWidth() : 0);
                if (maxWidth < len) {
                    maxWidth = len;
                }
                if (maxHeight >= (hi = this.getCombinedHeight(img != null ? img.getIconHeight() : 0))) continue;
                maxHeight = hi;
            }
            int w = maxWidth + this.gap * 2 + this.padding * 2;
            int h = maxHeight + this.padding * 2;
            if (w > this.width) {
                this.width = w;
            }
            if (h > this.height) {
                this.height = h;
            }
            if (this.width > (dp = this.getDesktopPane()).getWidth()) {
                this.width = dp.getWidth();
            }
        } else {
            this.height = this.getFont().getHeight() + this.padding * 2;
            this.width = this.getFont().getWidth("999") + this.padding * 2;
        }
    }

    public boolean processKeyEvent(KeyEvent keypad) {
        boolean letgo;
        if (keypad.justPressedAction(2)) {
            this.leftPress = true;
        } else if (keypad.justReleasedAction(2)) {
            this.leftPress = false;
        } else if (keypad.justPressedAction(5)) {
            this.rightPress = true;
        } else if (keypad.justReleasedAction(5)) {
            this.rightPress = false;
        }
        this.fire();
        boolean bl = letgo = keypad.justReleasedAction(2) || keypad.justReleasedAction(5);
        if (letgo) {
            this.repaint();
        }
        return this.leftPress || this.rightPress || letgo;
    }

    private void fire() {
        Object newVal = null;
        if (this.leftPress && !this.rightPress) {
            newVal = this.getPreviousValue();
        }
        if (this.rightPress && !this.leftPress) {
            newVal = this.getNextValue();
        }
        if (newVal != null) {
            this.setValue(newVal);
        }
    }

    public void paintComponent(Graphics2D g) {
        super.paintComponent(g);
        Border insets = this.getInsets();
        if (this.leftPress && this.leftSelectedIcon != null) {
            this.leftSelectedIcon.paintIcon(this, g, -insets.getLeft(), (this.height - this.leftSelectedIcon.getIconHeight()) / 2);
        } else if (this.leftUnselectedIcon != null) {
            this.leftUnselectedIcon.paintIcon(this, g, -insets.getLeft(), (this.height - this.leftUnselectedIcon.getIconHeight()) / 2);
        }
        if (this.rightPress && this.rightSelectedIcon != null) {
            this.rightSelectedIcon.paintIcon(this, g, this.width + insets.getRight() - this.rightUnselectedIcon.getIconWidth(), (this.height - this.rightUnselectedIcon.getIconHeight()) / 2);
        } else if (this.rightUnselectedIcon != null) {
            this.rightUnselectedIcon.paintIcon(this, g, this.width + insets.getRight() - this.rightUnselectedIcon.getIconWidth(), (this.height - this.rightUnselectedIcon.getIconHeight()) / 2);
        }
    }

    public void setText(String a) {
        throw new IllegalArgumentException();
    }

    public String getDefaultName() {
        return "Spinner";
    }

    public void updateUI() {
        super.updateUI();
        this.leftSelectedIcon = (Icon)this.theme.getProperty("iconLeft", 8);
        this.leftUnselectedIcon = (Icon)this.theme.getProperty("iconLeft", 0);
        this.rightSelectedIcon = (Icon)this.theme.getProperty("iconRight", 8);
        this.rightUnselectedIcon = (Icon)this.theme.getProperty("iconRight", 0);
    }

    public Object getNextValue() {
        if (this.list != null) {
            if (this.index < this.list.size() - 1) {
                return this.list.elementAt(this.index + 1);
            }
            if (!this.list.isEmpty() && this.continuous) {
                return this.list.elementAt(0);
            }
        } else {
            if (this.index < this.max) {
                return new Integer(this.index + 1);
            }
            if (this.max != this.min && this.continuous) {
                return new Integer(this.min);
            }
        }
        return null;
    }

    public Object getPreviousValue() {
        if (this.list != null) {
            if (this.index > 0) {
                return this.list.elementAt(this.index - 1);
            }
            if (!this.list.isEmpty() && this.continuous) {
                return this.list.elementAt(this.list.size() - 1);
            }
        } else {
            if (this.index > this.min) {
                return new Integer(this.index - 1);
            }
            if (this.max != this.min && this.continuous) {
                return new Integer(this.max);
            }
        }
        return null;
    }

    public Object getValue() {
        if (this.list != null) {
            return this.list.elementAt(this.index);
        }
        return new Integer(this.index);
    }

    public void setValue(Object value) {
        int old = this.index;
        if (this.list != null) {
            this.index = this.list.indexOf(value);
        } else if (value instanceof Integer) {
            this.index = (Integer)value;
        }
        super.setValue(value);
        if (old != this.index && this.chl != null) {
            this.chl.changeEvent(this, this.index);
        }
        this.repaint();
    }

    public void setList(Vector data) {
        this.list = data;
        if (data != null) {
            if (!this.list.isEmpty() && this.list.firstElement() != null) {
                this.setValue(this.list.firstElement());
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaximum(int maximum) {
        this.max = maximum;
    }

    public void setMinimum(int minimum) {
        this.min = minimum;
    }
}

