/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.layout;

import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.ButtonGroup;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.border.LineBorder;
import net.yura.mobile.gui.border.TitledBorder;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.CheckBox;
import net.yura.mobile.gui.components.ComboBox;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.gui.components.Label;
import net.yura.mobile.gui.components.List;
import net.yura.mobile.gui.components.Menu;
import net.yura.mobile.gui.components.MenuBar;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.ProgressBar;
import net.yura.mobile.gui.components.RadioButton;
import net.yura.mobile.gui.components.ScrollPane;
import net.yura.mobile.gui.components.Slider;
import net.yura.mobile.gui.components.Spinner;
import net.yura.mobile.gui.components.TabbedPane;
import net.yura.mobile.gui.components.Table;
import net.yura.mobile.gui.components.TextArea;
import net.yura.mobile.gui.components.TextComponent;
import net.yura.mobile.gui.components.TextField;
import net.yura.mobile.gui.components.TextPane;
import net.yura.mobile.gui.components.Window;
import net.yura.mobile.gui.layout.GridBagConstraints;
import net.yura.mobile.gui.layout.GridBagLayout;
import net.yura.mobile.gui.plaf.SynthLookAndFeel;
import net.yura.mobile.io.UTF8InputStreamReader;
import net.yura.mobile.io.kxml2.KXmlParser;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.Option;
import net.yura.mobile.util.Properties;
import net.yura.mobile.util.StringUtil;

public class XULLoader {
    public static final int VK_ALT = 18;
    public static final int VK_ESCAPE = 27;
    public static final int VK_F1 = 112;
    public static final int VK_F2 = 113;
    private Hashtable components = new Hashtable();
    private Hashtable groups = new Hashtable();
    private Component root;
    private Properties i18nProperties;
    public static final Hashtable EMPTY = new Hashtable(0);
    private static float density = 1.0f;

    public static XULLoader load(InputStream is, ActionListener listener) throws Exception {
        XULLoader loader = new XULLoader();
        loader.load(new UTF8InputStreamReader(is), listener);
        return loader;
    }

    public static XULLoader load(InputStream is, ActionListener listener, Properties properties) throws Exception {
        XULLoader loader = new XULLoader();
        loader.load(new UTF8InputStreamReader(is), listener, properties);
        return loader;
    }

    public void swapComponent(String name, Component comp) {
        Component old = this.find(name);
        Component parent = old.getParent();
        if (parent instanceof Panel) {
            Panel p = (Panel)parent;
            GridBagConstraints constr = (GridBagConstraints)p.getConstraints().get(old);
            int index = p.getComponents().indexOf(old);
            p.remove(old);
            p.insert(comp, constr, index);
        } else if (parent instanceof MenuBar) {
            MenuBar b = (MenuBar)parent;
            int i = b.getItems().indexOf(old);
            b.remove(old);
            b.insert(comp, i);
        }
        comp.setName(old.getName());
        this.components.put(name, comp);
    }

    public void load(Reader reader, ActionListener listener) throws Exception {
        KXmlParser parser = new KXmlParser();
        parser.setInput(reader);
        parser.nextTag();
        GridBagConstraints rt = (GridBagConstraints)this.readObject(parser, listener);
        this.root = rt.component;
    }

    public void load(Reader reader, ActionListener listener, Properties properties) throws Exception {
        this.i18nProperties = properties;
        this.load(reader, listener);
    }

    private String getPropertyText(String key, boolean i18n) {
        if (i18n) {
            String translated;
            if (this.i18nProperties != null && (translated = this.i18nProperties.getProperty(key)) != null) {
                return translated;
            }
            return "???" + key + "???";
        }
        return key;
    }

    public Hashtable getGroups() {
        return this.groups;
    }

    public Component find(String name) {
        return (Component)this.components.get(name);
    }

    public Component getRoot() {
        return this.root;
    }

    public Hashtable getFormData() {
        Hashtable<String, String> data = new Hashtable<String, String>();
        Enumeration enu = this.components.keys();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            Component comp = (Component)this.components.get(name);
            if (comp instanceof TextComponent) {
                data.put(name, ((TextComponent)comp).getText());
                continue;
            }
            if (comp instanceof ComboBox) {
                Object object = ((ComboBox)comp).getSelectedItem();
                String value = null;
                value = object instanceof String ? (String)object : (object instanceof Option ? ((Option)object).getKey() : String.valueOf(object));
                data.put(name, value);
                continue;
            }
            if (!(comp instanceof Button)) continue;
            data.put(name, String.valueOf(((Button)comp).isSelected()));
        }
        return data;
    }

    public void setFormData(Hashtable data) {
        Enumeration componentNames = data.keys();
        while (componentNames.hasMoreElements()) {
            String componentName = (String)componentNames.nextElement();
            Object value = data.get(componentName);
            Component component = this.find(componentName);
            if (component == null) continue;
            if (component instanceof TextComponent) {
                ((TextComponent)component).setText((String)value);
                continue;
            }
            if (component instanceof ComboBox) {
                if ("null".equals(value)) continue;
                int index = -1;
                ComboBox combo = (ComboBox)component;
                Vector items = combo.getItems();
                for (int i = 0; i < items.size(); ++i) {
                    Object item = items.elementAt(i);
                    if (item instanceof String) {
                        if (!((String)item).equals(value)) continue;
                        index = i;
                        break;
                    }
                    if (!(item instanceof Option) || !((Option)item).getKey().equals(value)) continue;
                    index = i;
                    break;
                }
                if (index <= -1) continue;
                combo.setSelectedIndex(index);
                continue;
            }
            if (!(component instanceof Button)) continue;
            ((Button)component).setSelected("true".equals(value));
        }
    }

    public Object readObject(KXmlParser parser, ActionListener listener) throws Exception {
        Hashtable<String, String> properties;
        String name = parser.getName();
        String property = parser.getAttributeValue(null, "property");
        if (property != null) {
            String[] cProperties = StringUtil.split(property, ';');
            properties = new Hashtable<String, String>(cProperties.length);
            if (0 < cProperties.length) {
                for (int x = 0; x < cProperties.length; ++x) {
                    String[] aproperty = StringUtil.split(cProperties[x], '=');
                    if (2 == aproperty.length) {
                        properties.put(aproperty[0], aproperty[1]);
                        continue;
                    }
                    Logger.warn("property does not have a key and value: " + cProperties[x]);
                }
            }
        } else {
            properties = EMPTY;
        }
        return this.readObject(parser, listener, name, properties);
    }

    public Object readObject(KXmlParser parser, ActionListener listener, String name, Hashtable properties) throws Exception {
        if (name.equals("panel")) {
            Panel panel = (Panel)XULLoader.newComponent(Panel.class, properties);
            panel = this.readPanel(parser, panel, listener);
            return this.readUIObject(parser, panel, listener, properties);
        }
        if (name.equals("dialog")) {
            Frame frame = (Frame)XULLoader.newComponent(Frame.class, properties);
            frame.setClosable(false);
            frame.setMaximizable(false);
            GridBagLayout layout = this.readLayout(parser);
            frame.getContentPane().setLayout(layout);
            String title = null;
            boolean i18n = false;
            int count = parser.getAttributeCount();
            for (int c = 0; c < count; ++c) {
                String key = parser.getAttributeName(c);
                String value = parser.getAttributeValue(c);
                if ("icon".equals(key)) {
                    frame.setIconImage(this.loadIcon(value));
                    continue;
                }
                if ("text".equals(key)) {
                    title = value;
                    continue;
                }
                if ("i18n".equals(key)) {
                    i18n = "true".equals(value);
                    continue;
                }
                if ("scrollable".equals(key)) {
                    Panel p = frame.getContentPane();
                    ScrollPane sp = new ScrollPane();
                    frame.setContentPane(sp);
                    sp.add(p);
                    continue;
                }
                if ("closable".equals(key)) {
                    frame.setClosable("true".equalsIgnoreCase(value));
                    continue;
                }
                if (!"maximizable".equals(key)) continue;
                frame.setMaximizable("true".equalsIgnoreCase(value));
            }
            String undecorated = (String)properties.get("undecorated");
            if (undecorated != null) {
                frame.setUndecorated("true".equalsIgnoreCase(undecorated));
            }
            if (title != null) {
                frame.setTitle(this.getPropertyText(title, i18n));
            }
            return this.readUIObject(parser, frame, listener, properties);
        }
        if (name.equals("tabbedpane")) {
            TabbedPane tabbedpane = (TabbedPane)XULLoader.newComponent(TabbedPane.class, properties);
            String pvalue = parser.getAttributeValue(null, "placement");
            int placement = 16;
            if ("left".equals(pvalue)) {
                placement = 4;
            } else if ("bottom".equals(pvalue)) {
                placement = 32;
            } else if ("right".equals(pvalue)) {
                placement = 8;
            }
            tabbedpane.setTabPlacement(placement);
            return this.readUIObject(parser, tabbedpane, listener, properties);
        }
        if (name.equals("tab")) {
            Tab tab = new Tab();
            this.readOption(parser, tab);
            while (parser.nextTag() != 3) {
                Object obj = this.readObject(parser, listener);
                if (tab.component == null) {
                    tab.component = ((GridBagConstraints)obj).component;
                    continue;
                }
                Logger.debug("ignored item in tab: " + obj);
            }
            return tab;
        }
        if (name.equals("progressbar")) {
            ProgressBar progress = (ProgressBar)XULLoader.newComponent(ProgressBar.class, properties);
            return this.readUIObject(parser, progress, listener, properties);
        }
        if (name.equals("spinbox")) {
            Spinner spinner = (Spinner)XULLoader.newComponent(Spinner.class, properties);
            int count = parser.getAttributeCount();
            for (int c = 0; c < count; ++c) {
                String key = parser.getAttributeName(c);
                String value = parser.getAttributeValue(c);
                if ("minimum".equals(key)) {
                    spinner.setMinimum(Integer.parseInt(value));
                    continue;
                }
                if ("maximum".equals(key)) {
                    spinner.setMaximum(Integer.parseInt(value));
                    continue;
                }
                if (!"text".equals(key)) continue;
                spinner.setValue(Integer.valueOf(value));
            }
            return this.readUIObject(parser, spinner, listener, properties);
        }
        if (name.equals("datespinbox")) {
            Spinner spinner = (Spinner)XULLoader.newComponent(Spinner.class, properties);
            return this.readUIObject(parser, spinner, listener, properties);
        }
        if (name.equals("button") || "menuitem".equals(name) || "togglebutton".equals(name)) {
            Button button = (Button)XULLoader.newComponent(Button.class, properties);
            this.readButton(parser, button, listener, properties);
            return this.readUIObject(parser, button, listener, properties);
        }
        if (name.equals("checkbox") || "checkboxmenuitem".equals(name)) {
            Button checkbox = this.readCheckbox(parser, listener, properties);
            return this.readUIObject(parser, checkbox, listener, properties);
        }
        if (name.equals("separator")) {
            Component separator = Menu.makeSeparator();
            return this.readUIObject(parser, separator, listener, properties);
        }
        if (name.equals("combobox")) {
            ComboBox combobox = (ComboBox)XULLoader.newComponent(ComboBox.class, properties);
            combobox.setItems(new Vector());
            this.readButton(parser, combobox, listener, properties);
            String selected = parser.getAttributeValue(null, "selected");
            int selectedIndex = selected == null ? -1 : Integer.parseInt(selected);
            GridBagConstraints constraints = this.readUIObject(parser, combobox, listener, properties);
            if (combobox.getItemCount() > selectedIndex && selectedIndex != -1) {
                combobox.setSelectedIndex(selectedIndex);
            }
            return constraints;
        }
        if (name.equals("list")) {
            List list = (List)XULLoader.newComponent(List.class, properties);
            int count = parser.getAttributeCount();
            for (int c = 0; c < count; ++c) {
                String key = parser.getAttributeName(c);
                String value = parser.getAttributeValue(c);
                if (!"action".equals(key)) continue;
                list.setActionCommand(value);
                if (listener == null) continue;
                list.addActionListener(listener);
            }
            String fixedCellHeight = (String)properties.get("fixedCellHeight");
            if (fixedCellHeight != null) {
                list.setFixedCellHeight(this.adjustSizeToDensity(fixedCellHeight));
            }
            return this.readUIObject(parser, list, listener, properties);
        }
        if (name.equals("textfield")) {
            TextField textfield = (TextField)XULLoader.newComponent(TextField.class, properties);
            this.readTextComponent(parser, textfield, listener, properties);
            return this.readUIObject(parser, textfield, listener, properties);
        }
        if (name.equals("passwordfield")) {
            TextField textfield = (TextField)XULLoader.newComponent(TextField.class, properties);
            textfield.setConstraints(65536);
            this.readTextComponent(parser, textfield, listener, properties);
            return this.readUIObject(parser, textfield, listener, properties);
        }
        if (name.equals("numericfield")) {
            TextField textfield = (TextField)XULLoader.newComponent(TextField.class, properties);
            textfield.setConstraints(2);
            this.readTextComponent(parser, textfield, listener, properties);
            return this.readUIObject(parser, textfield, listener, properties);
        }
        if (name.equals("textarea")) {
            Class clazz = properties.get("halign") != null ? TextPane.class : TextArea.class;
            Component textarea = XULLoader.newComponent(clazz, properties);
            this.readTextComponent(parser, textarea, listener, properties);
            return this.readUIObject(parser, textarea, listener, properties);
        }
        if (name.equals("label")) {
            Label label = (Label)XULLoader.newComponent(Label.class, properties);
            this.readLabel(parser, label, properties);
            return this.readUIObject(parser, label, listener, properties);
        }
        if (name.equals("menubar")) {
            MenuBar menubar = (MenuBar)XULLoader.newComponent(MenuBar.class, properties);
            return this.readUIObject(parser, menubar, listener, properties);
        }
        if (name.equals("menu")) {
            Menu menu = (Menu)XULLoader.newComponent(Menu.class, properties);
            this.readButton(parser, menu, listener, properties);
            return this.readUIObject(parser, menu, listener, properties);
        }
        if (name.equals("choice") || name.equals("item")) {
            Option op = new Option();
            this.readOption(parser, op);
            parser.skipSubTree();
            return op;
        }
        if (name.equals("table")) {
            Table table = (Table)XULLoader.newComponent(Table.class, properties);
            return this.readUIObject(parser, table, listener, properties);
        }
        if (name.equals("slider")) {
            Slider slider = (Slider)XULLoader.newComponent(Slider.class, properties);
            int count = parser.getAttributeCount();
            for (int c = 0; c < count; ++c) {
                String key = parser.getAttributeName(c);
                String value = parser.getAttributeValue(c);
                if (!"orientation".equals(key)) continue;
                slider.setHorizontal(!"vertical".equals(value));
            }
            return this.readUIObject(parser, slider, listener, properties);
        }
        if ("popupmenu".equals(name)) {
            Window popupmenu = Menu.makePopup();
            return this.readUIObject(parser, popupmenu, listener, properties);
        }
        Logger.debug("unknown object found: " + name);
        Label unknown = new Label("unknown item: " + name);
        return this.readUIObject(parser, unknown, listener, properties);
    }

    public static Component newComponent(Class theClass, Hashtable properties) throws Exception {
        String otherClass = (String)properties.get("class");
        if (otherClass != null) {
            theClass = Class.forName(otherClass);
        }
        return (Component)theClass.newInstance();
    }

    protected Panel readPanel(KXmlParser parser, Panel panel, ActionListener listener) {
        String border = null;
        String text = null;
        boolean i18n = false;
        boolean scrollable = false;
        int count = parser.getAttributeCount();
        for (int c = 0; c < count; ++c) {
            String key = parser.getAttributeName(c);
            String value = parser.getAttributeValue(c);
            if ("border".equals(key)) {
                border = value;
                continue;
            }
            if ("text".equals(key)) {
                text = value;
                continue;
            }
            if ("i18n".equals(key)) {
                i18n = "true".equals(value);
                continue;
            }
            if (!"scrollable".equals(key)) continue;
            scrollable = "true".equalsIgnoreCase(value);
        }
        GridBagLayout layout = this.readLayout(parser);
        panel.setLayout(layout);
        panel = scrollable ? new ScrollPane(panel) : panel;
        Border border2 = null;
        if (border != null) {
            border2 = new LineBorder();
        }
        if (text != null) {
            border2 = new TitledBorder(border2, this.getPropertyText(text, i18n), new Label().getFont());
        }
        if (border2 != null) {
            panel.setBorder(border2);
        }
        return panel;
    }

    protected void readButton(KXmlParser parser, Button button, ActionListener listener, Hashtable properties) {
        int count = parser.getAttributeCount();
        for (int c = 0; c < count; ++c) {
            String key = parser.getAttributeName(c);
            String value = parser.getAttributeValue(c);
            if ("action".equals(key)) {
                button.setActionCommand(value);
                if (listener == null) continue;
                button.addActionListener(listener);
                continue;
            }
            if ("mnemonic".equals(key)) {
                int mnemonic = Integer.parseInt(value);
                switch (mnemonic) {
                    case 18: {
                        mnemonic = -12;
                        break;
                    }
                    case 27: {
                        mnemonic = -11;
                        break;
                    }
                    case 112: {
                        mnemonic = -6;
                        break;
                    }
                    case 113: {
                        mnemonic = -7;
                        break;
                    }
                    default: {
                        if (mnemonic < 65 || mnemonic > 90) break;
                        mnemonic = Character.toLowerCase((char)mnemonic);
                    }
                }
                button.setMnemonic(mnemonic);
                continue;
            }
            if ("type".equals(key)) {
                if ("default".equals(value)) {
                    button.setMnemonic(-6);
                    continue;
                }
                if ("cancel".equals(value)) {
                    button.setMnemonic(-11);
                    continue;
                }
                if (!"link".equals(value)) continue;
                button.setName("Link");
                continue;
            }
            if ("selected".equals(key)) {
                button.setSelected("true".equalsIgnoreCase(value));
                continue;
            }
            if (!"group".equals(key)) continue;
            ButtonGroup g = (ButtonGroup)this.groups.get(value);
            if (g == null) {
                g = new ButtonGroup();
                this.groups.put(value, g);
            }
            g.add(button);
        }
        String rolloverIcon = (String)properties.get("rolloverIcon");
        if (rolloverIcon != null) {
            button.setRolloverIcon(this.loadIcon(rolloverIcon));
        }
        this.readLabel(parser, button, properties);
    }

    protected Button readCheckbox(KXmlParser parser, ActionListener listener, Hashtable properties) throws Exception {
        String group = null;
        int count = parser.getAttributeCount();
        for (int c = 0; c < count; ++c) {
            String key = parser.getAttributeName(c);
            String value = parser.getAttributeValue(c);
            if (!"group".equals(key)) continue;
            group = value;
            break;
        }
        Class theClass = group == null ? CheckBox.class : RadioButton.class;
        Button checkbox = (Button)XULLoader.newComponent(theClass, properties);
        this.readButton(parser, checkbox, listener, properties);
        return checkbox;
    }

    public void readLabel(KXmlParser parser, Label label, Hashtable properties) {
        String margin;
        String hTextPos;
        String vTextPos;
        String vAlignment;
        int pos;
        String labelText = null;
        boolean i18n = false;
        int count = parser.getAttributeCount();
        for (int c = 0; c < count; ++c) {
            String key = parser.getAttributeName(c);
            String value = parser.getAttributeValue(c);
            if ("text".equals(key)) {
                if (label instanceof ComboBox) continue;
                labelText = value;
                continue;
            }
            if ("i18n".equals(key)) {
                i18n = "true".equals(value);
                continue;
            }
            if ("icon".equals(key)) {
                label.setIcon(this.loadIcon(value));
                continue;
            }
            if (!"alignment".equals(key)) continue;
            pos = XULLoader.position(value, true);
            label.setHorizontalAlignment(pos);
        }
        String gap = (String)properties.get("gap");
        if (gap != null) {
            label.setIconTextGap(this.adjustSizeToDensity(gap));
        }
        if ((vAlignment = (String)properties.get("valign")) != null) {
            int pos2 = XULLoader.position(vAlignment, false);
            label.setVerticalAlignment(pos2);
        }
        if ((vTextPos = (String)properties.get("vTextPos")) != null) {
            pos = XULLoader.position(vTextPos, false);
            label.setVerticalTextPosition(pos);
        }
        if ((hTextPos = (String)properties.get("hTextPos")) != null) {
            int pos3 = XULLoader.position(hTextPos, true);
            label.setHorizontalTextPosition(pos3);
        }
        if ((margin = (String)properties.get("margin")) != null) {
            label.setMargin(this.adjustSizeToDensity(margin));
        }
        if (labelText != null) {
            label.setText(this.getPropertyText(labelText, i18n));
        }
    }

    public static int position(String pos, boolean horror) {
        if ("center".equals(pos)) {
            return horror ? 1 : 2;
        }
        if ("right".equals(pos)) {
            return 8;
        }
        if ("left".equals(pos)) {
            return 4;
        }
        if ("top".equals(pos)) {
            return 16;
        }
        if ("bottom".equals(pos)) {
            return 32;
        }
        Logger.warn("unknown position " + pos);
        return 0;
    }

    public Icon loadIcon(String value) {
        try {
            return new Icon(value);
        }
        catch (Exception ex) {
            Logger.warn("cant load " + value, ex);
            return null;
        }
    }

    private GridBagLayout readLayout(KXmlParser parser) {
        int columns = 0;
        int gap = 0;
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        int count = parser.getAttributeCount();
        for (int c = 0; c < count; ++c) {
            String key = parser.getAttributeName(c);
            String value = parser.getAttributeValue(c);
            if ("columns".equals(key)) {
                columns = Integer.parseInt(value);
                continue;
            }
            if ("gap".equals(key)) {
                gap = this.adjustSizeToDensity(value);
                continue;
            }
            if ("top".equals(key)) {
                top = this.adjustSizeToDensity(value);
                continue;
            }
            if ("bottom".equals(key)) {
                bottom = this.adjustSizeToDensity(value);
                continue;
            }
            if ("left".equals(key)) {
                left = this.adjustSizeToDensity(value);
                continue;
            }
            if (!"right".equals(key)) continue;
            right = this.adjustSizeToDensity(value);
        }
        return new GridBagLayout(columns, gap, top, bottom, left, right);
    }

    protected void readTextComponent(KXmlParser parser, Component text, ActionListener listener, Hashtable properties) {
        TextPane pane;
        String maxsize;
        String textLabel = null;
        Font font = null;
        boolean i18n = false;
        int count = parser.getAttributeCount();
        for (int c = 0; c < count; ++c) {
            String key = parser.getAttributeName(c);
            String value = parser.getAttributeValue(c);
            if ("text".equals(key)) {
                textLabel = value;
                continue;
            }
            if ("i18n".equals(key)) {
                i18n = "true".equals(value);
                continue;
            }
            if ("editable".equals(key)) {
                text.setFocusable("true".equals(value));
                continue;
            }
            if ("wrap".equals(key)) {
                if (!(text instanceof TextArea)) continue;
                ((TextArea)text).setLineWrap("true".equals(value));
                continue;
            }
            if ("columns".equals(key)) {
                if (!(text instanceof TextComponent)) continue;
                ((TextComponent)text).setPreferredSize(((TextComponent)text).getFont().getWidth('W') * Integer.parseInt(value), ((TextComponent)text).getPreferredHeight());
                continue;
            }
            if ("rows".equals(key)) {
                if (!(text instanceof TextArea)) continue;
                ((TextArea)text).setPreferredSize(((TextArea)text).getPreferredWidth(), ((TextArea)text).getFont().getHeight() * Integer.parseInt(value));
                continue;
            }
            if ("action".equals(key)) {
                if (!(text instanceof TextField)) continue;
                ((TextField)text).setActionCommand(value);
                if (listener == null) continue;
                ((TextField)text).addActionListener(listener);
                continue;
            }
            if (!"font".equals(key)) continue;
            String name = null;
            boolean bold = false;
            boolean italic = false;
            int size = 0;
            String[] st = StringUtil.split(value, ' ');
            for (int i = 0; i < st.length; ++i) {
                String token = st[i];
                if ("bold".equalsIgnoreCase(token)) {
                    bold = true;
                    continue;
                }
                if ("italic".equalsIgnoreCase(token)) {
                    italic = true;
                    continue;
                }
                try {
                    size = -Integer.parseInt(token);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    if ("SMALL".equals(token) || "MEDIUM".equals(token) || "LARGE".equals(token)) {
                        size = SynthLookAndFeel.getFontSize(token);
                        continue;
                    }
                    name = name == null ? token : name + ' ' + token;
                }
            }
            font = new Font(SynthLookAndFeel.getFontName(name), (bold ? 1 : 0) | (italic ? 2 : 0), size == 0 ? 0 : size);
        }
        String constraint = (String)properties.get("constraint");
        if (constraint != null && text instanceof TextComponent) {
            ((TextComponent)text).setConstraints(Integer.parseInt(constraint));
        }
        if ((maxsize = (String)properties.get("maxsize")) != null && text instanceof TextComponent) {
            ((TextComponent)text).setMaxSize(Integer.parseInt(maxsize));
        }
        if (textLabel != null) {
            String thetext = this.getPropertyText(textLabel, i18n);
            if (text instanceof TextComponent) {
                ((TextComponent)text).setText(thetext);
            } else if (text instanceof TextPane) {
                ((TextPane)text).setText(thetext);
            }
        }
        if (font != null) {
            if (text instanceof TextComponent) {
                ((TextComponent)text).setFont(font);
            } else if (text instanceof TextPane) {
                pane = (TextPane)text;
                TextPane.TextStyle style = new TextPane.TextStyle();
                style.addFont(font, 0);
                pane.setParagraphAttributes(0, pane.getText().length(), style);
            }
        }
        if (text instanceof TextPane) {
            pane = (TextPane)text;
            pane.setActionListener(listener);
            String hAlignment = (String)properties.get("halign");
            if (hAlignment != null) {
                int align;
                int pos = XULLoader.position(hAlignment, true);
                switch (pos) {
                    case 1: {
                        align = 1;
                        break;
                    }
                    case 8: {
                        align = 2;
                        break;
                    }
                    default: {
                        align = 0;
                    }
                }
                TextPane.TextStyle style = new TextPane.TextStyle();
                style.setAlignment(align);
                pane.setParagraphAttributes(0, pane.getText().length(), style);
            }
        }
    }

    private void readOption(KXmlParser parser, Option op) {
        String label = null;
        boolean i18n = false;
        int count = parser.getAttributeCount();
        for (int c = 0; c < count; ++c) {
            String key = parser.getAttributeName(c);
            String value = parser.getAttributeValue(c);
            if ("text".equals(key)) {
                label = value;
                continue;
            }
            if ("i18n".equals(key)) {
                i18n = "true".equals(value);
                continue;
            }
            if ("name".equals(key)) {
                op.setKey(value);
                continue;
            }
            if ("tooltip".equals(key)) {
                op.setTip(value);
                continue;
            }
            if (!"icon".equals(key)) continue;
            op.setIcon(this.loadIcon(value));
        }
        if (label != null) {
            op.setValue(this.getPropertyText(label, i18n));
        }
    }

    public GridBagConstraints readUIObject(KXmlParser parser, Component comp, ActionListener listener, Hashtable properties) throws Exception {
        GridBagConstraints uiobject = new GridBagConstraints();
        uiobject.component = comp;
        int count = parser.getAttributeCount();
        for (int c = 0; c < count; ++c) {
            String key = parser.getAttributeName(c);
            String value = parser.getAttributeValue(c);
            if ("weightx".equals(key)) {
                uiobject.weightx = Integer.parseInt(value);
                continue;
            }
            if ("weighty".equals(key)) {
                uiobject.weighty = Integer.parseInt(value);
                continue;
            }
            if ("colspan".equals(key)) {
                uiobject.colSpan = Integer.parseInt(value);
                continue;
            }
            if ("rowspan".equals(key)) {
                uiobject.rowSpan = Integer.parseInt(value);
                continue;
            }
            if ("valign".equals(key)) {
                uiobject.valign = value;
                continue;
            }
            if ("halign".equals(key)) {
                uiobject.halign = value;
                continue;
            }
            if ("background".equals(key)) {
                comp.setBackground(Graphics2D.parseColor(value.substring(1), 16));
                continue;
            }
            if ("foreground".equals(key)) {
                comp.setForeground(Graphics2D.parseColor(value.substring(1), 16));
                continue;
            }
            if ("height".equals(key)) {
                comp.setPreferredSize(comp.getPreferredWidth(), this.adjustSizeToDensity(value));
                continue;
            }
            if ("width".equals(key)) {
                comp.setPreferredSize(this.adjustSizeToDensity(value), comp.getPreferredHeight());
                continue;
            }
            if ("name".equals(key)) {
                this.components.put(value, comp);
                continue;
            }
            if ("tooltip".equals(key)) {
                comp.setToolTipText(value);
                continue;
            }
            if ("visible".equals(key)) {
                comp.setVisible("true".equals(value));
                continue;
            }
            if (!"enabled".equals(key)) continue;
            comp.setFocusable("true".equals(value));
        }
        String plafname = (String)properties.get("plafname");
        if (plafname != null) {
            comp.setName(plafname);
        }
        if (uiobject.weightx > 0 && uiobject.weighty > 0 && comp instanceof Frame) {
            ((Frame)comp).setMaximum(true);
        }
        while (parser.nextTag() != 3) {
            Object obj = this.readObject(parser, listener);
            if (obj instanceof GridBagConstraints && ((GridBagConstraints)obj).component instanceof Window) {
                comp.setPopupMenu((Window)((GridBagConstraints)obj).component);
                continue;
            }
            if (comp instanceof Frame) {
                Panel panel = ((Frame)comp).getContentPane();
                if (panel instanceof ScrollPane) {
                    panel = (Panel)((ScrollPane)panel).getView();
                }
                Component component = ((GridBagConstraints)obj).component;
                if (panel.getComponentCount() == 0 && component instanceof MenuBar) {
                    ((Frame)comp).setMenuBar((MenuBar)component);
                    continue;
                }
                panel.add(component, obj);
                continue;
            }
            if (comp instanceof Window) {
                Menu.getPopupMenu((Window)comp).add(((GridBagConstraints)obj).component);
                continue;
            }
            if (comp instanceof TabbedPane) {
                Tab tab = (Tab)obj;
                ((TabbedPane)comp).addTab(tab.getValue(), tab.getIcon(), tab.component, tab.getToolTip());
                continue;
            }
            if (comp instanceof ScrollPane) {
                ((Panel)((ScrollPane)comp).getView()).add(((GridBagConstraints)obj).component, obj);
                continue;
            }
            if (comp instanceof Panel) {
                ((Panel)comp).add(((GridBagConstraints)obj).component, obj);
                continue;
            }
            if (comp instanceof ComboBox) {
                ((ComboBox)comp).getItems().addElement(obj);
                continue;
            }
            if (comp instanceof Menu) {
                ((Menu)comp).add(((GridBagConstraints)obj).component);
                continue;
            }
            if (comp instanceof MenuBar) {
                ((MenuBar)comp).add(((GridBagConstraints)obj).component);
                continue;
            }
            if (comp instanceof List) {
                ((List)comp).getItems().addElement(obj);
                continue;
            }
            throw new RuntimeException("why are we here???");
        }
        return uiobject;
    }

    private int adjustSizeToDensity(String value) {
        int r = Integer.parseInt(value);
        return XULLoader.adjustSizeToDensity(r);
    }

    public static int adjustSizeToDensity(int mdpiSize) {
        return (int)(density * (float)mdpiSize + 0.5f);
    }

    static {
        try {
            String d = System.getProperty("display.density");
            if (d != null) {
                density = Float.parseFloat(d);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class Tab
    extends Option {
        private Component component;

        Tab() {
        }
    }
}

