/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */ 

package javax.servlet.jsp.el;

import java.text.MessageFormat;

/**
 * Represents a parsing error encountered while parsing an EL expression.
 *
 * @since 2.0
 */

public class ELParseException extends ELException {

 //-------------------------------------
  /**
   * Creates an ELParseException with no detail message.
   */
  public ELParseException ()
  {
    super ();
  }

  //-------------------------------------
  /**
   * Creates an ELParseException with the provided detail message.
   *
   * @param pMessage the detail message
   **/
  public ELParseException (String pMessage)
  {
    super (pMessage);
  }

  //-------------------------------------
}
