/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system;

import java.util.HashMap;
import java.util.regex.Pattern;

public class Version {
    private static final Pattern VERSION_SPLIT_PATTERN = Pattern.compile("[^0-9]");
    private static final HashMap<Version, Version> all = new HashMap();
    private int major;
    private Integer minor;
    private Integer revision;

    public static Version parse(String versionString) {
        String[] version = VERSION_SPLIT_PATTERN.split(versionString);
        int major = Version.parsePart(version, 0);
        Integer minor = Version.parsePart(version, 1);
        Integer revision = Version.parsePart(version, 2);
        return Version.get(major, minor, revision);
    }

    private static Integer parsePart(String[] version, int idx) {
        if (version.length <= idx) {
            return null;
        }
        String part = version[idx];
        if (part == null || part.isEmpty()) {
            return null;
        }
        return Integer.valueOf(part);
    }

    public static synchronized Version get(int major, Integer minor, Integer revision) {
        Version test = new Version(major, minor, revision);
        Version found = all.get(test);
        if (found == null) {
            all.put(test, test);
            found = test;
        }
        return found;
    }

    private Version(int major, Integer minor, Integer revision) {
        if (minor == null && revision != null) {
            throw new IllegalArgumentException("revision cannot have value when minor does not");
        }
        this.major = major;
        this.minor = minor;
        this.revision = revision;
    }

    public int getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public int getMinorValue() {
        return this.minor != null ? this.minor : 0;
    }

    public Integer getRevision() {
        return this.revision;
    }

    public int getRevisionValue() {
        return this.revision != null ? this.revision : 0;
    }

    public boolean isMinimum(int major) {
        return this.major >= major;
    }

    public boolean isMinimum(int major, int minor) {
        if (this.major < major) {
            return false;
        }
        if (this.major > major) {
            return true;
        }
        return this.getMinorValue() >= minor;
    }

    public boolean isMinimum(int major, int minor, int revision) {
        if (this.major < major) {
            return false;
        }
        if (this.major > major) {
            return true;
        }
        if (this.minor < minor) {
            return false;
        }
        if (this.minor > minor) {
            return true;
        }
        return this.getRevisionValue() >= revision;
    }

    public boolean isMinimum(Version ver) {
        return this.isMinimum(ver.getMajor(), ver.getMinorValue(), ver.getRevisionValue());
    }

    public boolean isEqual(int major) {
        return major == this.major;
    }

    public boolean isEqual(int major, int minor) {
        return major == this.major && this.getMinorValue() == minor;
    }

    public boolean isEqual(int major, int minor, int revision) {
        return major == this.major && this.getMinorValue() == minor && this.getRevisionValue() == revision;
    }

    public boolean isEqual(Version ver) {
        return this.isEqual(ver.getMajor(), ver.getMinorValue(), ver.getRevisionValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        if (this.minor != null) {
            sb.append('.').append(this.minor);
            if (this.revision != null) {
                sb.append('.').append(this.revision);
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + (this.minor == null ? 0 : this.minor.hashCode());
        result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor == null ? other.minor != null : !this.minor.equals(other.minor)) {
            return false;
        }
        return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
    }
}

