/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.Arrays;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.guava.Joiner;
import java.io.IOException;

public class OidVectors
extends SimpleProcProvider {
    public OidVectors() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new Arrays.BinEncoder(), (Type.Codec.Decoder)new Arrays.BinDecoder(), "oidvector");
    }

    static class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Integer[].class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Array;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.append("");
                return;
            }
            Integer[] oids = (Integer[])val;
            Object[] items = new String[oids.length];
            for (int c = 0; c < oids.length; ++c) {
                items[c] = Long.toString((long)oids[c].intValue() & 0xFFFFFFFFL);
            }
            Joiner.on(' ').appendTo(buffer, items);
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Array;
        }

        @Override
        public Class<?> getOutputType() {
            return Integer[].class;
        }

        @Override
        public Object decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            int length = buffer.length();
            Integer[] instance = null;
            if (length != 0) {
                String[] items = buffer.toString().split(" ");
                Integer[] oids = new Integer[items.length];
                for (int c = 0; c < items.length; ++c) {
                    oids[c] = (int)(Long.parseLong(items[c]) & 0xFFFFFFFFL);
                }
                instance = oids;
            }
            return instance;
        }
    }
}

