/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.validation;

import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class CompositeValidationStatus
extends ValidationStatus {
    private Map<Integer, List<Integer>> validatorToMessagesMap = new HashMap<Integer, List<Integer>>();

    CompositeValidationStatus() {
    }

    @Override
    void addMessage(ValidationMessage message) {
    }

    @Override
    void addMessage(Collection<ValidationMessage> messages) {
    }

    @Override
    void removeMessage(ValidationMessage message) {
    }

    @Override
    void removeMessage(Collection<? extends ValidationMessage> messages) {
    }

    @Override
    void clearMessages() {
    }

    void addMessage(Validator validator, List<? extends ValidationMessage> messages) {
        if (messages.isEmpty()) {
            return;
        }
        int validatorHash = System.identityHashCode(validator);
        if (!this.validatorToMessagesMap.containsKey(validatorHash)) {
            this.validatorToMessagesMap.put(validatorHash, new ArrayList());
        }
        List<Integer> messageHashesOfThisValidator = this.validatorToMessagesMap.get(validatorHash);
        messages.stream().map(System::identityHashCode).forEach(messageHashesOfThisValidator::add);
        this.getMessagesInternal().addAll(messages);
    }

    void removeMessage(Validator validator, List<? extends ValidationMessage> messages) {
        if (messages.isEmpty()) {
            return;
        }
        int validatorHash = System.identityHashCode(validator);
        if (this.validatorToMessagesMap.containsKey(validatorHash)) {
            List<Integer> messageHashesOfThisValidator = this.validatorToMessagesMap.get(validatorHash);
            List hashesOfMessagesToRemove = messages.stream().filter(m3 -> {
                int hash = System.identityHashCode(m3);
                return messageHashesOfThisValidator.contains(hash);
            }).map(System::identityHashCode).collect(Collectors.toList());
            this.getMessagesInternal().removeIf(message -> {
                int hash = System.identityHashCode(message);
                return hashesOfMessagesToRemove.contains(hash);
            });
            messageHashesOfThisValidator.removeAll(hashesOfMessagesToRemove);
            if (messageHashesOfThisValidator.isEmpty()) {
                this.validatorToMessagesMap.remove(validatorHash);
            }
        }
    }

    void removeMessage(Validator validator) {
        int validatorHash = System.identityHashCode(validator);
        if (this.validatorToMessagesMap.containsKey(validatorHash)) {
            List<Integer> messageHashesOfThisValidator = this.validatorToMessagesMap.get(validatorHash);
            this.getMessagesInternal().removeIf(message -> {
                int hash = System.identityHashCode(message);
                return messageHashesOfThisValidator.contains(hash);
            });
            this.validatorToMessagesMap.remove(validatorHash);
        }
    }
}

